/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.test.factory;

import java.util.UUID;
import org.apache.rocketmq.client.consumer.DefaultMQPullConsumer;
import org.apache.rocketmq.client.consumer.MessageSelector;
import org.apache.rocketmq.test.client.rmq.RMQBroadCastConsumer;
import org.apache.rocketmq.test.client.rmq.RMQNormalConsumer;
import org.apache.rocketmq.test.client.rmq.RMQPopClient;
import org.apache.rocketmq.test.client.rmq.RMQPopConsumer;
import org.apache.rocketmq.test.client.rmq.RMQSqlConsumer;
import org.apache.rocketmq.test.listener.AbstractListener;

public class ConsumerFactory {
    public static RMQNormalConsumer getRMQNormalConsumer(String nsAddr, String consumerGroup, String topic, String subExpression, AbstractListener listener) {
        return ConsumerFactory.getRMQNormalConsumer(nsAddr, consumerGroup, topic, subExpression, listener, false);
    }

    public static RMQNormalConsumer getRMQNormalConsumer(String nsAddr, String consumerGroup, String topic, String subExpression, AbstractListener listener, boolean useTLS) {
        RMQNormalConsumer consumer = new RMQNormalConsumer(nsAddr, topic, subExpression, consumerGroup, listener);
        consumer.create(useTLS);
        consumer.start();
        return consumer;
    }

    public static RMQBroadCastConsumer getRMQBroadCastConsumer(String nsAddr, String consumerGroup, String topic, String subExpression, AbstractListener listner) {
        RMQBroadCastConsumer consumer = new RMQBroadCastConsumer(nsAddr, topic, subExpression, consumerGroup, listner);
        consumer.create();
        consumer.start();
        return consumer;
    }

    public static RMQSqlConsumer getRMQSqlConsumer(String nsAddr, String consumerGroup, String topic, MessageSelector selector, AbstractListener listner) {
        RMQSqlConsumer consumer = new RMQSqlConsumer(nsAddr, topic, selector, consumerGroup, listner);
        consumer.create();
        consumer.start();
        return consumer;
    }

    public static RMQPopConsumer getRMQPopConsumer(String nsAddr, String consumerGroup, String topic, String subExpression, AbstractListener listener) {
        RMQPopConsumer consumer = new RMQPopConsumer(nsAddr, topic, subExpression, consumerGroup, listener);
        consumer.create();
        consumer.start();
        return consumer;
    }

    public static RMQPopClient getRMQPopClient() {
        RMQPopClient client = new RMQPopClient();
        client.create();
        client.start();
        return client;
    }

    public static DefaultMQPullConsumer getRMQPullConsumer(String nsAddr, String consumerGroup) throws Exception {
        DefaultMQPullConsumer defaultMQPullConsumer = new DefaultMQPullConsumer(consumerGroup);
        defaultMQPullConsumer.setInstanceName(UUID.randomUUID().toString());
        defaultMQPullConsumer.setNamesrvAddr(nsAddr);
        defaultMQPullConsumer.start();
        return defaultMQPullConsumer;
    }
}

