/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.test.client.rmq;

import java.nio.charset.StandardCharsets;
import org.apache.rocketmq.client.exception.MQClientException;
import org.apache.rocketmq.client.producer.LocalTransactionState;
import org.apache.rocketmq.client.producer.TransactionListener;
import org.apache.rocketmq.client.producer.TransactionMQProducer;
import org.apache.rocketmq.client.producer.TransactionSendResult;
import org.apache.rocketmq.common.Pair;
import org.apache.rocketmq.common.message.Message;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.apache.rocketmq.test.clientinterface.AbstractMQProducer;
import org.apache.rocketmq.test.sendresult.ResultWrapper;

public class RMQTransactionalProducer
extends AbstractMQProducer {
    private static Logger logger = LoggerFactory.getLogger(RMQTransactionalProducer.class);
    private TransactionMQProducer producer = null;
    private String nsAddr = null;

    public RMQTransactionalProducer(String nsAddr, String topic, TransactionListener transactionListener) {
        this(nsAddr, topic, false, transactionListener);
    }

    public RMQTransactionalProducer(String nsAddr, String topic, boolean useTLS, TransactionListener transactionListener) {
        super(topic);
        this.nsAddr = nsAddr;
        this.create(useTLS, transactionListener);
        this.start();
    }

    protected void create(boolean useTLS, TransactionListener transactionListener) {
        this.producer = new TransactionMQProducer();
        this.producer.setProducerGroup(this.getProducerGroupName());
        this.producer.setInstanceName(this.getProducerInstanceName());
        this.producer.setTransactionListener(transactionListener);
        this.producer.setUseTLS(useTLS);
        if (this.nsAddr != null) {
            this.producer.setNamesrvAddr(this.nsAddr);
        }
    }

    public void start() {
        try {
            this.producer.start();
            super.setStartSuccess(true);
        }
        catch (MQClientException e) {
            super.setStartSuccess(false);
            logger.error("", (Throwable)e);
            e.printStackTrace();
        }
    }

    @Override
    public ResultWrapper send(Object msg, Object arg) {
        boolean commitMsg = ((Pair)arg).getObject2() == LocalTransactionState.COMMIT_MESSAGE;
        TransactionSendResult metaqResult = null;
        Message message = (Message)msg;
        try {
            long start = System.currentTimeMillis();
            metaqResult = this.producer.sendMessageInTransaction(message, arg);
            this.msgRTs.addData(System.currentTimeMillis() - start);
            if (this.isDebug) {
                logger.info("SendResult: {}", (Object)metaqResult);
            }
            this.sendResult.setMsgId(metaqResult.getMsgId());
            this.sendResult.setSendResult(true);
            this.sendResult.setBrokerIp(metaqResult.getMessageQueue().getBrokerName());
            if (commitMsg) {
                this.msgBodys.addData(new String(message.getBody(), StandardCharsets.UTF_8));
            }
            this.originMsgs.addData(msg);
            this.originMsgIndex.put(new String(message.getBody(), StandardCharsets.UTF_8), metaqResult);
        }
        catch (MQClientException e) {
            if (this.isDebug) {
                e.printStackTrace();
            }
            this.sendResult.setSendResult(false);
            this.sendResult.setSendException((Exception)((Object)e));
            this.errorMsgs.addData(msg);
        }
        return this.sendResult;
    }

    @Override
    public void shutdown() {
        this.producer.shutdown();
    }
}

