/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.test.client.rmq;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import org.apache.rocketmq.client.consumer.AckResult;
import org.apache.rocketmq.client.consumer.PopResult;
import org.apache.rocketmq.client.exception.MQBrokerException;
import org.apache.rocketmq.client.exception.MQClientException;
import org.apache.rocketmq.common.message.MessageQueue;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.apache.rocketmq.remoting.exception.RemotingException;
import org.apache.rocketmq.test.client.rmq.RMQNormalConsumer;
import org.apache.rocketmq.test.client.rmq.RMQPopClient;
import org.apache.rocketmq.test.factory.ConsumerFactory;
import org.apache.rocketmq.test.listener.AbstractListener;

public class RMQPopConsumer
extends RMQNormalConsumer {
    private static final Logger log = LoggerFactory.getLogger(RMQPopConsumer.class);
    public static final long POP_TIMEOUT = 3000L;
    public static final long DEFAULT_INVISIBLE_TIME = 30000L;
    private RMQPopClient client;
    private int maxNum = 16;

    public RMQPopConsumer(String nsAddr, String topic, String subExpression, String consumerGroup, AbstractListener listener) {
        super(nsAddr, topic, subExpression, consumerGroup, listener);
    }

    public RMQPopConsumer(String nsAddr, String topic, String subExpression, String consumerGroup, AbstractListener listener, int maxNum) {
        super(nsAddr, topic, subExpression, consumerGroup, listener);
        this.maxNum = maxNum;
    }

    @Override
    public void start() {
        this.client = ConsumerFactory.getRMQPopClient();
        log.info(String.format("consumer[%s] started!", this.consumerGroup));
    }

    @Override
    public void shutdown() {
        this.client.shutdown();
    }

    public PopResult pop(String brokerAddr, MessageQueue mq) throws Exception {
        return this.pop(brokerAddr, mq, 30000L, 5000L);
    }

    public PopResult pop(String brokerAddr, MessageQueue mq, long invisibleTime, long timeout) throws InterruptedException, RemotingException, MQClientException, MQBrokerException, ExecutionException, TimeoutException {
        CompletableFuture<PopResult> future = this.client.popMessageAsync(brokerAddr, mq, invisibleTime, this.maxNum, this.consumerGroup, timeout, true, 0, false, "TAG", "*");
        return future.get();
    }

    public PopResult popOrderly(String brokerAddr, MessageQueue mq) throws Exception {
        return this.popOrderly(brokerAddr, mq, 30000L, 5000L);
    }

    public PopResult popOrderly(String brokerAddr, MessageQueue mq, long invisibleTime, long timeout) throws InterruptedException, ExecutionException {
        CompletableFuture<PopResult> future = this.client.popMessageAsync(brokerAddr, mq, invisibleTime, this.maxNum, this.consumerGroup, timeout, true, 0, true, "TAG", "*");
        return future.get();
    }

    public CompletableFuture<AckResult> ackAsync(String brokerAddr, String extraInfo) {
        return this.client.ackMessageAsync(brokerAddr, this.topic, this.consumerGroup, extraInfo);
    }
}

