/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.test.client.rmq;

import java.util.concurrent.CompletableFuture;
import org.apache.rocketmq.client.ClientConfig;
import org.apache.rocketmq.client.consumer.AckCallback;
import org.apache.rocketmq.client.consumer.AckResult;
import org.apache.rocketmq.client.consumer.PopCallback;
import org.apache.rocketmq.client.consumer.PopResult;
import org.apache.rocketmq.client.impl.ClientRemotingProcessor;
import org.apache.rocketmq.client.impl.MQClientAPIImpl;
import org.apache.rocketmq.common.message.MessageQueue;
import org.apache.rocketmq.remoting.netty.NettyClientConfig;
import org.apache.rocketmq.remoting.protocol.header.AckMessageRequestHeader;
import org.apache.rocketmq.remoting.protocol.header.ChangeInvisibleTimeRequestHeader;
import org.apache.rocketmq.remoting.protocol.header.ExtraInfoUtil;
import org.apache.rocketmq.remoting.protocol.header.PopMessageRequestHeader;
import org.apache.rocketmq.test.clientinterface.MQConsumer;
import org.apache.rocketmq.test.util.RandomUtil;

public class RMQPopClient
implements MQConsumer {
    private static final long DEFAULT_TIMEOUT = 3000L;
    private MQClientAPIImpl mqClientAPI;

    @Override
    public void create() {
        this.create(false);
    }

    @Override
    public void create(boolean useTLS) {
        ClientConfig clientConfig = new ClientConfig();
        clientConfig.setInstanceName(RandomUtil.getStringByUUID());
        NettyClientConfig nettyClientConfig = new NettyClientConfig();
        nettyClientConfig.setUseTLS(useTLS);
        this.mqClientAPI = new MQClientAPIImpl(nettyClientConfig, new ClientRemotingProcessor(null), null, clientConfig);
    }

    @Override
    public void start() {
        this.mqClientAPI.start();
    }

    @Override
    public void shutdown() {
        this.mqClientAPI.shutdown();
    }

    public CompletableFuture<PopResult> popMessageAsync(String brokerAddr, MessageQueue mq, long invisibleTime, int maxNums, String consumerGroup, long timeout, boolean poll, int initMode, boolean order, String expressionType, String expression) {
        PopMessageRequestHeader requestHeader = new PopMessageRequestHeader();
        requestHeader.setConsumerGroup(consumerGroup);
        requestHeader.setTopic(mq.getTopic());
        requestHeader.setQueueId(Integer.valueOf(mq.getQueueId()));
        requestHeader.setMaxMsgNums(maxNums);
        requestHeader.setInvisibleTime(invisibleTime);
        requestHeader.setInitMode(initMode);
        requestHeader.setExpType(expressionType);
        requestHeader.setExp(expression);
        requestHeader.setOrder(Boolean.valueOf(order));
        if (poll) {
            requestHeader.setPollTime(timeout);
            requestHeader.setBornTime(System.currentTimeMillis());
            timeout += 10000L;
        }
        final CompletableFuture<PopResult> future = new CompletableFuture<PopResult>();
        try {
            this.mqClientAPI.popMessageAsync(mq.getBrokerName(), brokerAddr, requestHeader, timeout, new PopCallback(){

                public void onSuccess(PopResult popResult) {
                    future.complete(popResult);
                }

                public void onException(Throwable e) {
                    future.completeExceptionally(e);
                }
            });
        }
        catch (Throwable t) {
            future.completeExceptionally(t);
        }
        return future;
    }

    public CompletableFuture<AckResult> ackMessageAsync(String brokerAddr, String topic, String consumerGroup, String extraInfo) {
        String[] extraInfoStrs = ExtraInfoUtil.split((String)extraInfo);
        AckMessageRequestHeader requestHeader = new AckMessageRequestHeader();
        requestHeader.setTopic(ExtraInfoUtil.getRealTopic((String[])extraInfoStrs, (String)topic, (String)consumerGroup));
        requestHeader.setQueueId(Integer.valueOf(ExtraInfoUtil.getQueueId((String[])extraInfoStrs)));
        requestHeader.setOffset(Long.valueOf(ExtraInfoUtil.getQueueOffset((String[])extraInfoStrs)));
        requestHeader.setConsumerGroup(consumerGroup);
        requestHeader.setExtraInfo(extraInfo);
        final CompletableFuture<AckResult> future = new CompletableFuture<AckResult>();
        try {
            this.mqClientAPI.ackMessageAsync(brokerAddr, 3000L, new AckCallback(){

                public void onSuccess(AckResult ackResult) {
                    future.complete(ackResult);
                }

                public void onException(Throwable e) {
                    future.completeExceptionally(e);
                }
            }, requestHeader);
        }
        catch (Throwable t) {
            future.completeExceptionally(t);
        }
        return future;
    }

    public CompletableFuture<AckResult> changeInvisibleTimeAsync(String brokerAddr, String brokerName, String topic, String consumerGroup, String extraInfo, long invisibleTime) {
        String[] extraInfoStrs = ExtraInfoUtil.split((String)extraInfo);
        ChangeInvisibleTimeRequestHeader requestHeader = new ChangeInvisibleTimeRequestHeader();
        requestHeader.setTopic(ExtraInfoUtil.getRealTopic((String[])extraInfoStrs, (String)topic, (String)consumerGroup));
        requestHeader.setQueueId(Integer.valueOf(ExtraInfoUtil.getQueueId((String[])extraInfoStrs)));
        requestHeader.setOffset(Long.valueOf(ExtraInfoUtil.getQueueOffset((String[])extraInfoStrs)));
        requestHeader.setConsumerGroup(consumerGroup);
        requestHeader.setExtraInfo(extraInfo);
        requestHeader.setInvisibleTime(Long.valueOf(invisibleTime));
        final CompletableFuture<AckResult> future = new CompletableFuture<AckResult>();
        try {
            this.mqClientAPI.changeInvisibleTimeAsync(brokerName, brokerAddr, requestHeader, 3000L, new AckCallback(){

                public void onSuccess(AckResult ackResult) {
                    future.complete(ackResult);
                }

                public void onException(Throwable e) {
                    future.completeExceptionally(e);
                }
            });
        }
        catch (Throwable t) {
            future.completeExceptionally(t);
        }
        return future;
    }
}

