/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.test.client.rmq;

import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import org.apache.rocketmq.client.exception.MQClientException;
import org.apache.rocketmq.client.producer.DefaultMQProducer;
import org.apache.rocketmq.client.producer.SendResult;
import org.apache.rocketmq.client.producer.SendStatus;
import org.apache.rocketmq.common.message.Message;
import org.apache.rocketmq.common.message.MessageQueue;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.apache.rocketmq.test.clientinterface.AbstractMQProducer;
import org.apache.rocketmq.test.sendresult.ResultWrapper;

public class RMQNormalProducer
extends AbstractMQProducer {
    private static Logger logger = LoggerFactory.getLogger(RMQNormalProducer.class);
    private DefaultMQProducer producer = null;
    private String nsAddr = null;

    public RMQNormalProducer(String nsAddr, String topic) {
        this(nsAddr, topic, false);
    }

    public RMQNormalProducer(String nsAddr, String topic, boolean useTLS) {
        super(topic);
        this.nsAddr = nsAddr;
        this.create(useTLS);
        this.start();
    }

    public RMQNormalProducer(String nsAddr, String topic, String producerGroupName, String producerInstanceName) {
        this(nsAddr, topic, producerGroupName, producerInstanceName, false);
    }

    public RMQNormalProducer(String nsAddr, String topic, String producerGroupName, String producerInstanceName, boolean useTLS) {
        super(topic);
        this.producerGroupName = producerGroupName;
        this.producerInstanceName = producerInstanceName;
        this.nsAddr = nsAddr;
        this.create(useTLS);
        this.start();
    }

    public DefaultMQProducer getProducer() {
        return this.producer;
    }

    public void setProducer(DefaultMQProducer producer) {
        this.producer = producer;
    }

    protected void create(boolean useTLS) {
        this.producer = new DefaultMQProducer();
        this.producer.setProducerGroup(this.getProducerGroupName());
        this.producer.setInstanceName(this.getProducerInstanceName());
        this.producer.setUseTLS(useTLS);
        this.producer.setPollNameServerInterval(100);
        if (this.nsAddr != null) {
            this.producer.setNamesrvAddr(this.nsAddr);
        }
    }

    public void start() {
        try {
            this.producer.start();
            super.setStartSuccess(true);
        }
        catch (MQClientException e) {
            super.setStartSuccess(false);
            logger.error("producer start failed!");
            e.printStackTrace();
        }
    }

    @Override
    public ResultWrapper send(Object msg, Object orderKey) {
        SendResult internalSendResult = null;
        Message message = (Message)msg;
        try {
            long start = System.currentTimeMillis();
            internalSendResult = this.producer.send(message);
            this.msgRTs.addData(System.currentTimeMillis() - start);
            if (this.isDebug) {
                logger.info("SendResult: {}", (Object)internalSendResult);
            }
            this.sendResult.setMsgId(internalSendResult.getMsgId());
            this.sendResult.setSendResult(internalSendResult.getSendStatus().equals((Object)SendStatus.SEND_OK));
            this.sendResult.setBrokerIp(internalSendResult.getMessageQueue().getBrokerName());
            this.msgBodys.addData(new String(message.getBody(), StandardCharsets.UTF_8));
            this.originMsgs.addData(msg);
            this.originMsgIndex.put(new String(message.getBody(), StandardCharsets.UTF_8), internalSendResult);
        }
        catch (Exception e) {
            if (this.isDebug) {
                e.printStackTrace();
            }
            this.sendResult.setSendResult(false);
            this.sendResult.setSendException(e);
            this.errorMsgs.addData(msg);
        }
        return this.sendResult;
    }

    public void send(Map<MessageQueue, List<Object>> msgs) {
        for (MessageQueue mq : msgs.keySet()) {
            this.send(msgs.get(mq), mq);
        }
    }

    public void send(List<Object> msgs, MessageQueue mq) {
        for (Object msg : msgs) {
            this.sendMQ((Message)msg, mq);
        }
    }

    public void send(int num, MessageQueue mq) {
        for (int i = 0; i < num; ++i) {
            this.sendMQ((Message)this.getMessageByTag(null), mq);
        }
    }

    public ResultWrapper sendMQ(Message msg, MessageQueue mq) {
        SendResult internalSendResult = null;
        try {
            long start = System.currentTimeMillis();
            internalSendResult = this.producer.send(msg, mq);
            this.msgRTs.addData(System.currentTimeMillis() - start);
            if (this.isDebug) {
                logger.info("SendResult: {}", (Object)internalSendResult);
            }
            this.sendResult.setMsgId(internalSendResult.getMsgId());
            this.sendResult.setSendResult(internalSendResult.getSendStatus().equals((Object)SendStatus.SEND_OK));
            this.sendResult.setBrokerIp(internalSendResult.getMessageQueue().getBrokerName());
            this.msgBodys.addData(new String(msg.getBody(), StandardCharsets.UTF_8));
            this.originMsgs.addData(msg);
            this.originMsgIndex.put(new String(msg.getBody(), StandardCharsets.UTF_8), internalSendResult);
        }
        catch (Exception e) {
            if (this.isDebug) {
                e.printStackTrace();
            }
            this.sendResult.setSendResult(false);
            this.sendResult.setSendException(e);
            this.errorMsgs.addData(msg);
        }
        return this.sendResult;
    }

    @Override
    public void shutdown() {
        this.producer.shutdown();
    }

    @Override
    public List<MessageQueue> getMessageQueue() {
        List mqs = null;
        try {
            mqs = this.producer.fetchPublishMessageQueues(this.topic);
        }
        catch (MQClientException e) {
            e.printStackTrace();
        }
        return mqs;
    }
}

