/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.test.client.rmq;

import org.apache.rocketmq.client.consumer.DefaultMQPushConsumer;
import org.apache.rocketmq.client.consumer.listener.MessageListener;
import org.apache.rocketmq.client.exception.MQClientException;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.apache.rocketmq.test.clientinterface.AbstractMQConsumer;
import org.apache.rocketmq.test.listener.AbstractListener;
import org.apache.rocketmq.test.util.RandomUtil;

public class RMQNormalConsumer
extends AbstractMQConsumer {
    private static final Logger LOGGER = LoggerFactory.getLogger(RMQNormalConsumer.class);
    protected DefaultMQPushConsumer consumer = null;

    public RMQNormalConsumer(String nsAddr, String topic, String subExpression, String consumerGroup, AbstractListener listener) {
        super(nsAddr, topic, subExpression, consumerGroup, listener);
    }

    @Override
    public AbstractListener getListener() {
        return this.listener;
    }

    @Override
    public void setListener(AbstractListener listener) {
        this.listener = listener;
    }

    @Override
    public void create() {
        this.create(false);
    }

    @Override
    public void create(boolean useTLS) {
        this.consumer = new DefaultMQPushConsumer(this.consumerGroup);
        this.consumer.setInstanceName(RandomUtil.getStringByUUID());
        this.consumer.setNamesrvAddr(this.nsAddr);
        this.consumer.setPollNameServerInterval(100);
        try {
            this.consumer.subscribe(this.topic, this.subExpression);
        }
        catch (MQClientException e) {
            LOGGER.error("consumer subscribe failed!");
            e.printStackTrace();
        }
        this.consumer.setMessageListener((MessageListener)this.listener);
        this.consumer.setUseTLS(useTLS);
    }

    @Override
    public void start() {
        try {
            this.consumer.start();
            LOGGER.info(String.format("consumer[%s] started!", this.consumer.getConsumerGroup()));
        }
        catch (MQClientException e) {
            LOGGER.error("consumer start failed!");
            e.printStackTrace();
        }
    }

    public void subscribe(String topic, String subExpression) {
        try {
            this.consumer.subscribe(topic, subExpression);
        }
        catch (MQClientException e) {
            LOGGER.error("consumer subscribe failed!");
            e.printStackTrace();
        }
    }

    @Override
    public void shutdown() {
        this.consumer.shutdown();
    }

    @Override
    public void clearMsg() {
        this.listener.clearMsg();
    }

    public void restart() {
        this.consumer.shutdown();
        this.create();
        this.start();
    }

    public DefaultMQPushConsumer getConsumer() {
        return this.consumer;
    }
}

