/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.test.client.mq;

import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.apache.rocketmq.test.clientinterface.AbstractMQProducer;
import org.apache.rocketmq.test.util.TestUtil;

public class MQAsyncProducer {
    private static Logger logger = LoggerFactory.getLogger(MQAsyncProducer.class);
    private AbstractMQProducer producer = null;
    private long msgNum;
    private int intervalMills;
    private Thread sendT;
    private AtomicBoolean bPause = new AtomicBoolean(false);

    public MQAsyncProducer(final AbstractMQProducer producer, final long msgNum, final int intervalMills) {
        this.producer = producer;
        this.msgNum = msgNum;
        this.intervalMills = intervalMills;
        this.sendT = new Thread(new Runnable(){

            @Override
            public void run() {
                int i = 0;
                while ((long)i < msgNum) {
                    if (!MQAsyncProducer.this.bPause.get()) {
                        producer.send();
                        TestUtil.waitForMonment(intervalMills);
                    } else {
                        while (MQAsyncProducer.this.bPause.get()) {
                            TestUtil.waitForMonment(10L);
                        }
                    }
                    ++i;
                }
            }
        });
    }

    public void start() {
        this.sendT.start();
    }

    public void waitSendAll(int waitMills) {
        long startTime = System.currentTimeMillis();
        while ((long)(this.producer.getAllMsgBody().size() + this.producer.getSendErrorMsg().size()) < this.msgNum) {
            if (System.currentTimeMillis() - startTime < (long)waitMills) {
                TestUtil.waitForMonment(200L);
                continue;
            }
            logger.error(String.format("time elapse:%s, but the message sending has not finished", System.currentTimeMillis() - startTime));
            break;
        }
    }

    public void pauseProducer() {
        this.bPause.set(true);
    }

    public void notifyProducer() {
        this.bPause.set(false);
    }
}

