/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.test.util;

import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public final class TestUtil {
    private TestUtil() {
    }

    public static Long parseStringToLong(String s, Long defval) {
        Long val = defval;
        try {
            val = Long.parseLong(s);
        }
        catch (NumberFormatException e) {
            val = defval;
        }
        return val;
    }

    public static Integer parseStringToInteger(String s, Integer defval) {
        Integer val = defval;
        try {
            val = Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            val = defval;
        }
        return val;
    }

    public static String addQuoteToParamater(String param) {
        StringBuilder sb = new StringBuilder("'");
        sb.append(param).append("'");
        return sb.toString();
    }

    public static void waitForMonment(long time) {
        try {
            Thread.sleep(time);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public static void waitForSeconds(long time) {
        try {
            TimeUnit.SECONDS.sleep(time);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public static void waitForMinutes(long time) {
        try {
            TimeUnit.MINUTES.sleep(time);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public static void waitForInputQuit() {
        TestUtil.waitForInput("quit");
    }

    public static void waitForInput(String keyWord) {
        TestUtil.waitForInput(keyWord, String.format("The thread will wait until you input stop command[%s]:", keyWord));
    }

    public static void waitForInput(String keyWord, String info) {
        try {
            byte[] b = new byte[1024];
            int n = System.in.read(b);
            String s = new String(b, 0, n - 1).replace("\r", "").replace("\n", "");
            while (!s.equals(keyWord)) {
                n = System.in.read(b);
                s = new String(b, 0, n - 1);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static <K, V extends Comparable<? super V>> Map<K, V> sortByValue(Map<K, V> map) {
        LinkedList<Map.Entry<K, V>> list = new LinkedList<Map.Entry<K, V>>(map.entrySet());
        Collections.sort(list, new Comparator<Map.Entry<K, V>>(){

            @Override
            public int compare(Map.Entry<K, V> o1, Map.Entry<K, V> o2) {
                return ((Comparable)o1.getValue()).compareTo(o2.getValue());
            }
        });
        LinkedHashMap result = new LinkedHashMap();
        for (Map.Entry entry : list) {
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    }
}

