/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.test.util;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatUtil {
    private static Logger sysLogger = LoggerFactory.getLogger(StatUtil.class);
    private static Logger logger = LoggerFactory.getLogger((String)"StatLogger");
    private static final int MAX_KEY_NUM = Integer.parseInt(System.getProperty("stat.util.key.max.num", "10000"));
    private static volatile ConcurrentMap<String, Invoke> invokeCache = new ConcurrentHashMap<String, Invoke>(64);
    private static volatile ConcurrentMap<String, Map<Long, SecondInvoke>> secondInvokeCache = new ConcurrentHashMap<String, Map<Long, SecondInvoke>>(64);
    private static final int STAT_WINDOW_SECONDS = Integer.parseInt(System.getProperty("stat.win.seconds", "60"));
    private static final String SPLITTER = "|";
    private static ScheduledExecutorService daemon = Executors.newSingleThreadScheduledExecutor();

    private static void printInvokeStat() {
        ConcurrentMap<String, Invoke> tmp = invokeCache;
        invokeCache = new ConcurrentHashMap<String, Invoke>(64);
        sysLogger.warn("printInvokeStat key count:{}", (Object)tmp.size());
        for (Map.Entry entry : tmp.entrySet()) {
            String key = (String)entry.getKey();
            Invoke invoke = (Invoke)entry.getValue();
            logger.warn("{}", (Object)StatUtil.buildLog(key, invoke.topSecondPv.get(), invoke.totalPv.get(), invoke.failPv.get(), invoke.minRt.get(), invoke.maxRt.get(), invoke.sumRt.get()));
        }
    }

    private static void printSecondInvokeStat() {
        sysLogger.warn("printSecondInvokeStat key count:{}", (Object)secondInvokeCache.size());
        for (Map.Entry entry : secondInvokeCache.entrySet()) {
            String key = (String)entry.getKey();
            Map secondInvokeMap = (Map)entry.getValue();
            long totalPv = 0L;
            long failPv = 0L;
            long topSecondPv = 0L;
            long sumRt = 0L;
            long maxRt = 0L;
            long minRt = 0L;
            for (Map.Entry invokeEntry : secondInvokeMap.entrySet()) {
                long second = (Long)invokeEntry.getKey();
                SecondInvoke secondInvoke = (SecondInvoke)invokeEntry.getValue();
                if (StatUtil.nowSecond() - second >= (long)STAT_WINDOW_SECONDS) {
                    secondInvokeMap.remove(second);
                    continue;
                }
                long secondPv = secondInvoke.total.get();
                totalPv += secondPv;
                failPv += secondInvoke.fail.get();
                sumRt += secondInvoke.sumRt.get();
                if (maxRt < secondInvoke.maxRt.get()) {
                    maxRt = secondInvoke.maxRt.get();
                }
                if (minRt > secondInvoke.minRt.get()) {
                    minRt = secondInvoke.minRt.get();
                }
                if (topSecondPv >= secondPv) continue;
                topSecondPv = secondPv;
            }
            if (secondInvokeMap.isEmpty()) {
                secondInvokeCache.remove(key);
                continue;
            }
            logger.warn("{}", (Object)StatUtil.buildLog(key, topSecondPv, totalPv, failPv, minRt, maxRt, sumRt));
        }
    }

    private static String buildLog(String key, long topSecondPv, long totalPv, long failPv, long minRt, long maxRt, long sumRt) {
        StringBuilder sb = new StringBuilder();
        sb.append(SPLITTER);
        sb.append(key);
        sb.append(SPLITTER);
        sb.append(topSecondPv);
        sb.append(SPLITTER);
        int tps = new BigDecimal(totalPv).divide(new BigDecimal(STAT_WINDOW_SECONDS), 4).intValue();
        sb.append(tps);
        sb.append(SPLITTER);
        sb.append(totalPv);
        sb.append(SPLITTER);
        sb.append(failPv);
        sb.append(SPLITTER);
        sb.append(minRt);
        sb.append(SPLITTER);
        long avg = new BigDecimal(sumRt).divide(new BigDecimal(totalPv), 4).longValue();
        sb.append(avg);
        sb.append(SPLITTER);
        sb.append(maxRt);
        return sb.toString();
    }

    public static String buildKey(String ... keys) {
        if (keys == null || keys.length <= 0) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (String key : keys) {
            sb.append(key);
            sb.append(",");
        }
        sb.deleteCharAt(sb.length() - 1);
        return sb.toString();
    }

    public static void addInvoke(String key, long rt) {
        StatUtil.addInvoke(key, rt, true);
    }

    private static Invoke getAndSetInvoke(String key) {
        Invoke invoke = (Invoke)invokeCache.get(key);
        if (invoke == null) {
            invokeCache.putIfAbsent(key, new Invoke());
        }
        return (Invoke)invokeCache.get(key);
    }

    public static void addInvoke(String key, int num, long rt, boolean success) {
        if (invokeCache.size() > MAX_KEY_NUM || secondInvokeCache.size() > MAX_KEY_NUM) {
            return;
        }
        Invoke invoke = StatUtil.getAndSetInvoke(key);
        if (invoke == null) {
            return;
        }
        invoke.totalPv.getAndAdd(num);
        if (!success) {
            invoke.failPv.getAndAdd(num);
        }
        long now = StatUtil.nowSecond();
        AtomicLong oldSecond = invoke.second;
        if (oldSecond.get() == now) {
            invoke.secondPv.getAndAdd(num);
        } else if (oldSecond.compareAndSet(oldSecond.get(), now)) {
            if (invoke.secondPv.get() > invoke.topSecondPv.get()) {
                invoke.topSecondPv.set(invoke.secondPv.get());
            }
            invoke.secondPv.set(num);
        } else {
            invoke.secondPv.getAndAdd(num);
        }
        invoke.sumRt.addAndGet(rt);
        if (invoke.maxRt.get() < rt) {
            invoke.maxRt.set(rt);
        }
        if (invoke.minRt.get() > rt) {
            invoke.minRt.set(rt);
        }
    }

    public static void addInvoke(String key, long rt, boolean success) {
        if (invokeCache.size() > MAX_KEY_NUM || secondInvokeCache.size() > MAX_KEY_NUM) {
            return;
        }
        Invoke invoke = StatUtil.getAndSetInvoke(key);
        if (invoke == null) {
            return;
        }
        invoke.totalPv.getAndIncrement();
        if (!success) {
            invoke.failPv.getAndIncrement();
        }
        long now = StatUtil.nowSecond();
        AtomicLong oldSecond = invoke.second;
        if (oldSecond.get() == now) {
            invoke.secondPv.getAndIncrement();
        } else if (oldSecond.compareAndSet(oldSecond.get(), now)) {
            if (invoke.secondPv.get() > invoke.topSecondPv.get()) {
                invoke.topSecondPv.set(invoke.secondPv.get());
            }
            invoke.secondPv.set(1);
        } else {
            invoke.secondPv.getAndIncrement();
        }
        invoke.sumRt.addAndGet(rt);
        if (invoke.maxRt.get() < rt) {
            invoke.maxRt.set(rt);
        }
        if (invoke.minRt.get() > rt) {
            invoke.minRt.set(rt);
        }
    }

    public static SecondInvoke getAndSetSecondInvoke(String key) {
        Map secondInvokeMap;
        if (!secondInvokeCache.containsKey(key)) {
            secondInvokeCache.putIfAbsent(key, new ConcurrentHashMap(STAT_WINDOW_SECONDS));
        }
        if ((secondInvokeMap = (Map)secondInvokeCache.get(key)) == null) {
            return null;
        }
        long second = StatUtil.nowSecond();
        if (!secondInvokeMap.containsKey(second)) {
            secondInvokeMap.putIfAbsent(second, new SecondInvoke());
        }
        return (SecondInvoke)secondInvokeMap.get(second);
    }

    public static void addSecondInvoke(String key, long rt) {
        StatUtil.addSecondInvoke(key, rt, true);
    }

    public static void addSecondInvoke(String key, long rt, boolean success) {
        if (invokeCache.size() > MAX_KEY_NUM || secondInvokeCache.size() > MAX_KEY_NUM) {
            return;
        }
        SecondInvoke secondInvoke = StatUtil.getAndSetSecondInvoke(key);
        if (secondInvoke == null) {
            return;
        }
        secondInvoke.total.addAndGet(1L);
        if (!success) {
            secondInvoke.fail.addAndGet(1L);
        }
        secondInvoke.sumRt.addAndGet(rt);
        if (secondInvoke.maxRt.get() < rt) {
            secondInvoke.maxRt.set(rt);
        }
        if (secondInvoke.minRt.get() > rt) {
            secondInvoke.minRt.set(rt);
        }
    }

    public static void addPv(String key, long totalPv) {
        StatUtil.addPv(key, totalPv, true);
    }

    public static void addPv(String key, long totalPv, boolean success) {
        if (invokeCache.size() > MAX_KEY_NUM || secondInvokeCache.size() > MAX_KEY_NUM) {
            return;
        }
        if (totalPv <= 0L) {
            return;
        }
        Invoke invoke = StatUtil.getAndSetInvoke(key);
        if (invoke == null) {
            return;
        }
        invoke.totalPv.addAndGet(totalPv);
        if (!success) {
            invoke.failPv.addAndGet(totalPv);
        }
        long now = StatUtil.nowSecond();
        AtomicLong oldSecond = invoke.second;
        if (oldSecond.get() == now) {
            invoke.secondPv.addAndGet((int)totalPv);
        } else if (oldSecond.compareAndSet(oldSecond.get(), now)) {
            if (invoke.secondPv.get() > invoke.topSecondPv.get()) {
                invoke.topSecondPv.set(invoke.secondPv.get());
            }
            invoke.secondPv.set((int)totalPv);
        } else {
            invoke.secondPv.addAndGet((int)totalPv);
        }
    }

    public static void addSecondPv(String key, long totalPv) {
        StatUtil.addSecondPv(key, totalPv, true);
    }

    public static void addSecondPv(String key, long totalPv, boolean success) {
        if (invokeCache.size() > MAX_KEY_NUM || secondInvokeCache.size() > MAX_KEY_NUM) {
            return;
        }
        if (totalPv <= 0L) {
            return;
        }
        SecondInvoke secondInvoke = StatUtil.getAndSetSecondInvoke(key);
        if (secondInvoke == null) {
            return;
        }
        secondInvoke.total.addAndGet(totalPv);
        if (!success) {
            secondInvoke.fail.addAndGet(totalPv);
        }
    }

    public static boolean isOverFlow(String key, int tps) {
        return StatUtil.nowTps(key) >= tps;
    }

    public static int nowTps(String key) {
        SecondInvoke secondInvoke;
        Map secondInvokeMap = (Map)secondInvokeCache.get(key);
        if (secondInvokeMap != null && (secondInvoke = (SecondInvoke)secondInvokeMap.get(StatUtil.nowSecond())) != null) {
            return (int)secondInvoke.total.get();
        }
        Invoke invoke = (Invoke)invokeCache.get(key);
        if (invoke == null) {
            return 0;
        }
        AtomicLong oldSecond = invoke.second;
        if (oldSecond.get() == StatUtil.nowSecond()) {
            return invoke.secondPv.get();
        }
        return 0;
    }

    public static int totalPvInWindow(String key, int windowSeconds) {
        List<SecondInvoke> list = StatUtil.secondInvokeList(key, windowSeconds);
        long totalPv = 0L;
        for (int i = 0; i < windowSeconds && i < list.size(); ++i) {
            totalPv += list.get((int)i).total.get();
        }
        return (int)totalPv;
    }

    public static int failPvInWindow(String key, int windowSeconds) {
        List<SecondInvoke> list = StatUtil.secondInvokeList(key, windowSeconds);
        long failPv = 0L;
        for (int i = 0; i < windowSeconds && i < list.size(); ++i) {
            failPv += list.get((int)i).fail.get();
        }
        return (int)failPv;
    }

    public static int topTpsInWindow(String key, int windowSeconds) {
        List<SecondInvoke> list = StatUtil.secondInvokeList(key, windowSeconds);
        long topTps = 0L;
        for (int i = 0; i < windowSeconds && i < list.size(); ++i) {
            long secondPv = list.get((int)i).total.get();
            if (topTps >= secondPv) continue;
            topTps = secondPv;
        }
        return (int)topTps;
    }

    public static int avgRtInWindow(String key, int windowSeconds) {
        List<SecondInvoke> list = StatUtil.secondInvokeList(key, windowSeconds);
        long sumRt = 0L;
        long totalPv = 0L;
        for (int i = 0; i < windowSeconds && i < list.size(); ++i) {
            sumRt += list.get((int)i).sumRt.get();
            totalPv += list.get((int)i).total.get();
        }
        if (totalPv <= 0L) {
            return 0;
        }
        long avg = new BigDecimal(sumRt).divide(new BigDecimal(totalPv), 4).longValue();
        return (int)avg;
    }

    public static int maxRtInWindow(String key, int windowSeconds) {
        List<SecondInvoke> list = StatUtil.secondInvokeList(key, windowSeconds);
        long maxRt = 0L;
        long totalPv = 0L;
        for (int i = 0; i < windowSeconds && i < list.size(); ++i) {
            if (maxRt >= list.get((int)i).maxRt.get()) continue;
            maxRt = list.get((int)i).maxRt.get();
        }
        return (int)maxRt;
    }

    public static int minRtInWindow(String key, int windowSeconds) {
        List<SecondInvoke> list = StatUtil.secondInvokeList(key, windowSeconds);
        long minRt = 0L;
        long totalPv = 0L;
        for (int i = 0; i < windowSeconds && i < list.size(); ++i) {
            if (minRt >= list.get((int)i).minRt.get()) continue;
            minRt = list.get((int)i).minRt.get();
        }
        return (int)minRt;
    }

    private static List<SecondInvoke> secondInvokeList(String key, int windowSeconds) {
        if (windowSeconds > STAT_WINDOW_SECONDS || windowSeconds <= 0) {
            throw new IllegalArgumentException("windowSeconds Must Not be great than " + STAT_WINDOW_SECONDS);
        }
        Map secondInvokeMap = (Map)secondInvokeCache.get(key);
        if (secondInvokeMap == null || secondInvokeMap.isEmpty()) {
            return new ArrayList<SecondInvoke>();
        }
        ArrayList<SecondInvoke> list = new ArrayList<SecondInvoke>();
        list.addAll(secondInvokeMap.values());
        Collections.sort(list);
        return list;
    }

    private static long nowSecond() {
        return System.currentTimeMillis() / 1000L;
    }

    static /* synthetic */ long access$000() {
        return StatUtil.nowSecond();
    }

    static {
        daemon.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                try {
                    StatUtil.printInvokeStat();
                    StatUtil.printSecondInvokeStat();
                }
                catch (Exception e) {
                    logger.error("", (Throwable)e);
                }
            }
        }, STAT_WINDOW_SECONDS, STAT_WINDOW_SECONDS, TimeUnit.SECONDS);
    }

    static class SecondInvoke
    implements Comparable<SecondInvoke> {
        AtomicLong total = new AtomicLong();
        AtomicLong fail = new AtomicLong();
        AtomicLong sumRt = new AtomicLong();
        AtomicLong maxRt = new AtomicLong();
        AtomicLong minRt = new AtomicLong();
        Long second = StatUtil.access$000();

        SecondInvoke() {
        }

        @Override
        public int compareTo(SecondInvoke o) {
            return o.second.compareTo(this.second);
        }
    }

    static class Invoke {
        AtomicLong totalPv = new AtomicLong();
        AtomicLong failPv = new AtomicLong();
        AtomicLong sumRt = new AtomicLong();
        AtomicLong maxRt = new AtomicLong();
        AtomicLong minRt = new AtomicLong();
        AtomicInteger topSecondPv = new AtomicInteger();
        AtomicInteger secondPv = new AtomicInteger();
        AtomicLong second = new AtomicLong(System.currentTimeMillis() / 1000L);

        Invoke() {
        }
    }
}

