/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.worker;

import java.io.IOException;
import java.nio.file.Path;
import java.util.TreeMap;
import org.apache.pulsar.functions.utils.functions.FunctionArchive;
import org.apache.pulsar.functions.utils.functions.FunctionUtils;
import org.apache.pulsar.functions.worker.WorkerConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FunctionsManager {
    private static final Logger log = LoggerFactory.getLogger(FunctionsManager.class);
    private TreeMap<String, FunctionArchive> functions;

    public FunctionsManager(WorkerConfig workerConfig) throws IOException {
        this.functions = FunctionUtils.searchForFunctions((String)workerConfig.getFunctionsDirectory());
    }

    public FunctionArchive getFunction(String functionType) {
        return this.functions.get(functionType);
    }

    public Path getFunctionArchive(String functionType) {
        return this.functions.get(functionType).getArchivePath();
    }

    public void reloadFunctions(WorkerConfig workerConfig) throws IOException {
        this.functions = FunctionUtils.searchForFunctions((String)workerConfig.getFunctionsDirectory());
    }
}

