/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.transaction.timeout;

import io.netty.util.Timeout;
import io.netty.util.Timer;
import io.netty.util.TimerTask;
import java.time.Clock;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.apache.pulsar.broker.TransactionMetadataStoreService;
import org.apache.pulsar.client.api.transaction.TxnID;
import org.apache.pulsar.common.util.collections.TripleLongPriorityQueue;
import org.apache.pulsar.transaction.coordinator.TransactionTimeoutTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionTimeoutTrackerImpl
implements TransactionTimeoutTracker,
TimerTask {
    private static final Logger log = LoggerFactory.getLogger(TransactionTimeoutTrackerImpl.class);
    private final Timer timer;
    private final TripleLongPriorityQueue priorityQueue = new TripleLongPriorityQueue();
    private final long tickTimeMillis;
    private final Clock clock;
    private Timeout currentTimeout;
    private static final long INITIAL_TIMEOUT = 1L;
    private volatile long nowTaskTimeoutTime = 1L;
    private final long tcId;
    private final TransactionMetadataStoreService transactionMetadataStoreService;

    TransactionTimeoutTrackerImpl(long tcId, Timer timer, long tickTimeMillis, TransactionMetadataStoreService transactionMetadataStoreService) {
        this.tcId = tcId;
        this.transactionMetadataStoreService = transactionMetadataStoreService;
        this.timer = timer;
        this.tickTimeMillis = tickTimeMillis;
        this.clock = Clock.systemUTC();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<Boolean> addTransaction(long sequenceId, long timeout) {
        if (timeout < this.tickTimeMillis) {
            this.transactionMetadataStoreService.endTransactionForTimeout(new TxnID(this.tcId, sequenceId));
            return CompletableFuture.completedFuture(false);
        }
        TransactionTimeoutTrackerImpl transactionTimeoutTrackerImpl = this;
        synchronized (transactionTimeoutTrackerImpl) {
            long nowTime = this.clock.millis();
            long transactionTimeoutTime = nowTime + timeout;
            this.priorityQueue.add(transactionTimeoutTime, this.tcId, sequenceId);
            if (this.currentTimeout == null) {
                this.currentTimeout = this.timer.newTimeout((TimerTask)this, timeout, TimeUnit.MILLISECONDS);
                this.nowTaskTimeoutTime = transactionTimeoutTime;
            } else if (this.nowTaskTimeoutTime > transactionTimeoutTime) {
                if (this.currentTimeout.cancel() || this.currentTimeout.isExpired()) {
                    this.currentTimeout = this.timer.newTimeout((TimerTask)this, timeout, TimeUnit.MILLISECONDS);
                    this.nowTaskTimeoutTime = transactionTimeoutTime;
                }
            } else if (this.currentTimeout.isExpired()) {
                this.currentTimeout = this.timer.newTimeout((TimerTask)this, timeout, TimeUnit.MILLISECONDS);
                this.nowTaskTimeoutTime = transactionTimeoutTime;
            }
        }
        return CompletableFuture.completedFuture(false);
    }

    public void replayAddTransaction(long sequenceId, long timeout) {
        this.priorityQueue.add(timeout, this.tcId, sequenceId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        TransactionTimeoutTrackerImpl transactionTimeoutTrackerImpl = this;
        synchronized (transactionTimeoutTrackerImpl) {
            if (this.currentTimeout == null && !this.priorityQueue.isEmpty()) {
                this.currentTimeout = this.timer.newTimeout((TimerTask)this, this.priorityQueue.peekN1() - this.clock.millis(), TimeUnit.MILLISECONDS);
                this.nowTaskTimeoutTime = this.priorityQueue.peekN1();
            }
        }
    }

    public void close() {
        this.priorityQueue.close();
        if (this.currentTimeout != null) {
            this.currentTimeout.cancel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(Timeout timeout) {
        TransactionTimeoutTrackerImpl transactionTimeoutTrackerImpl = this;
        synchronized (transactionTimeoutTrackerImpl) {
            while (!this.priorityQueue.isEmpty()) {
                long nowTime;
                long timeoutTime = this.priorityQueue.peekN1();
                if (timeoutTime < (nowTime = this.clock.millis())) {
                    this.transactionMetadataStoreService.endTransactionForTimeout(new TxnID(this.priorityQueue.peekN2(), this.priorityQueue.peekN3()));
                    this.priorityQueue.pop();
                    continue;
                }
                this.currentTimeout = this.timer.newTimeout((TimerTask)this, timeoutTime - this.clock.millis(), TimeUnit.MILLISECONDS);
                this.nowTaskTimeoutTime = timeoutTime;
                break;
            }
        }
    }
}

