/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.stats.prometheus;

import java.util.HashMap;
import java.util.Map;
import org.apache.bookkeeper.mledger.util.StatsBuckets;
import org.apache.pulsar.broker.service.Consumer;
import org.apache.pulsar.broker.stats.prometheus.AggregatedConsumerStats;
import org.apache.pulsar.broker.stats.prometheus.AggregatedReplicationStats;
import org.apache.pulsar.broker.stats.prometheus.AggregatedSubscriptionStats;
import org.apache.pulsar.broker.stats.prometheus.ManagedLedgerStats;
import org.apache.pulsar.broker.stats.prometheus.TopicStats;
import org.apache.pulsar.compaction.CompactionRecord;

public class AggregatedNamespaceStats {
    public int topicsCount;
    public int subscriptionsCount;
    public int producersCount;
    public int consumersCount;
    public double rateIn;
    public double rateOut;
    public double throughputIn;
    public double throughputOut;
    public long messageAckRate;
    public long bytesInCounter;
    public long msgInCounter;
    public long bytesOutCounter;
    public long msgOutCounter;
    public ManagedLedgerStats managedLedgerStats = new ManagedLedgerStats();
    public long msgBacklog;
    public long msgDelayed;
    long backlogQuotaLimit;
    long backlogQuotaLimitTime;
    public Map<String, AggregatedReplicationStats> replicationStats = new HashMap<String, AggregatedReplicationStats>();
    public Map<String, AggregatedSubscriptionStats> subscriptionStats = new HashMap<String, AggregatedSubscriptionStats>();
    long compactionRemovedEventCount;
    long compactionSucceedCount;
    long compactionFailedCount;
    long compactionDurationTimeInMills;
    double compactionReadThroughput;
    double compactionWriteThroughput;
    long compactionCompactedEntriesCount;
    long compactionCompactedEntriesSize;
    StatsBuckets compactionLatencyBuckets = new StatsBuckets(CompactionRecord.WRITE_LATENCY_BUCKETS_USEC);
    int delayedTrackerMemoryUsage;

    void updateStats(TopicStats stats) {
        ++this.topicsCount;
        this.subscriptionsCount += stats.subscriptionsCount;
        this.producersCount += stats.producersCount;
        this.consumersCount += stats.consumersCount;
        this.rateIn += stats.rateIn;
        this.rateOut += stats.rateOut;
        this.throughputIn += stats.throughputIn;
        this.throughputOut += stats.throughputOut;
        this.bytesInCounter += stats.bytesInCounter;
        this.msgInCounter += stats.msgInCounter;
        this.bytesOutCounter += stats.bytesOutCounter;
        this.msgOutCounter += stats.msgOutCounter;
        this.delayedTrackerMemoryUsage += stats.delayedTrackerMemoryUsage;
        this.managedLedgerStats.storageSize += stats.managedLedgerStats.storageSize;
        this.managedLedgerStats.storageLogicalSize += stats.managedLedgerStats.storageLogicalSize;
        this.managedLedgerStats.backlogSize += stats.managedLedgerStats.backlogSize;
        this.managedLedgerStats.offloadedStorageUsed += stats.managedLedgerStats.offloadedStorageUsed;
        this.backlogQuotaLimit = Math.max(this.backlogQuotaLimit, stats.backlogQuotaLimit);
        this.backlogQuotaLimitTime = Math.max(this.backlogQuotaLimitTime, stats.backlogQuotaLimitTime);
        this.managedLedgerStats.storageWriteRate += stats.managedLedgerStats.storageWriteRate;
        this.managedLedgerStats.storageReadRate += stats.managedLedgerStats.storageReadRate;
        this.msgBacklog += stats.msgBacklog;
        this.managedLedgerStats.storageWriteLatencyBuckets.addAll(stats.managedLedgerStats.storageWriteLatencyBuckets);
        this.managedLedgerStats.storageLedgerWriteLatencyBuckets.addAll(stats.managedLedgerStats.storageLedgerWriteLatencyBuckets);
        this.managedLedgerStats.entrySizeBuckets.addAll(stats.managedLedgerStats.entrySizeBuckets);
        stats.replicationStats.forEach((n, as) -> {
            AggregatedReplicationStats replStats = this.replicationStats.computeIfAbsent((String)n, k -> new AggregatedReplicationStats());
            replStats.msgRateIn += as.msgRateIn;
            replStats.msgRateOut += as.msgRateOut;
            replStats.msgThroughputIn += as.msgThroughputIn;
            replStats.msgThroughputOut += as.msgThroughputOut;
            replStats.replicationBacklog += as.replicationBacklog;
            replStats.msgRateExpired += as.msgRateExpired;
            replStats.connectedCount += as.connectedCount;
            replStats.replicationDelayInSeconds += as.replicationDelayInSeconds;
        });
        stats.subscriptionStats.forEach((n, as) -> {
            AggregatedSubscriptionStats subsStats = this.subscriptionStats.computeIfAbsent((String)n, k -> new AggregatedSubscriptionStats());
            this.msgDelayed += as.msgDelayed;
            subsStats.blockedSubscriptionOnUnackedMsgs = as.blockedSubscriptionOnUnackedMsgs;
            subsStats.msgBacklog += as.msgBacklog;
            subsStats.msgBacklogNoDelayed += as.msgBacklogNoDelayed;
            subsStats.msgDelayed += as.msgDelayed;
            subsStats.msgRateRedeliver += as.msgRateRedeliver;
            subsStats.unackedMessages += as.unackedMessages;
            subsStats.filterProcessedMsgCount += as.filterProcessedMsgCount;
            subsStats.filterAcceptedMsgCount += as.filterAcceptedMsgCount;
            subsStats.filterRejectedMsgCount += as.filterRejectedMsgCount;
            subsStats.filterRescheduledMsgCount += as.filterRescheduledMsgCount;
            as.consumerStat.forEach((c, v) -> {
                AggregatedConsumerStats consumerStats = subsStats.consumerStat.computeIfAbsent((Consumer)c, k -> new AggregatedConsumerStats());
                consumerStats.blockedSubscriptionOnUnackedMsgs = v.blockedSubscriptionOnUnackedMsgs;
                consumerStats.msgRateRedeliver += v.msgRateRedeliver;
                consumerStats.unackedMessages += v.unackedMessages;
                this.messageAckRate = (long)((double)this.messageAckRate + v.msgAckRate);
            });
        });
        this.compactionRemovedEventCount += stats.compactionRemovedEventCount;
        this.compactionSucceedCount += stats.compactionSucceedCount;
        this.compactionFailedCount += stats.compactionFailedCount;
        this.compactionDurationTimeInMills += stats.compactionDurationTimeInMills;
        this.compactionReadThroughput += stats.compactionReadThroughput;
        this.compactionWriteThroughput += stats.compactionWriteThroughput;
        this.compactionCompactedEntriesCount += stats.compactionCompactedEntriesCount;
        this.compactionCompactedEntriesSize += stats.compactionCompactedEntriesSize;
        this.compactionLatencyBuckets.addAll(stats.compactionLatencyBuckets);
    }

    public void reset() {
        this.managedLedgerStats.reset();
        this.topicsCount = 0;
        this.subscriptionsCount = 0;
        this.producersCount = 0;
        this.consumersCount = 0;
        this.rateIn = 0.0;
        this.rateOut = 0.0;
        this.throughputIn = 0.0;
        this.throughputOut = 0.0;
        this.msgBacklog = 0L;
        this.msgDelayed = 0L;
        this.backlogQuotaLimit = 0L;
        this.backlogQuotaLimitTime = -1L;
        this.replicationStats.clear();
        this.subscriptionStats.clear();
        this.delayedTrackerMemoryUsage = 0;
    }
}

