/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.formats.muc;

import java.io.File;
import java.nio.charset.StandardCharsets;
import opennlp.tools.cmdline.ArgumentParser;
import opennlp.tools.cmdline.StreamFactoryRegistry;
import opennlp.tools.cmdline.TerminateToolException;
import opennlp.tools.cmdline.params.BasicFormatParams;
import opennlp.tools.cmdline.tokenizer.TokenizerModelLoader;
import opennlp.tools.commons.Internal;
import opennlp.tools.formats.AbstractSampleStreamFactory;
import opennlp.tools.formats.DirectorySampleStream;
import opennlp.tools.formats.convert.FileToStringSampleStream;
import opennlp.tools.formats.muc.MucNameSampleStream;
import opennlp.tools.namefind.NameSample;
import opennlp.tools.tokenize.ThreadSafeTokenizerME;
import opennlp.tools.tokenize.TokenizerModel;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.StringUtil;

@Internal
public class Muc6NameSampleStreamFactory
extends AbstractSampleStreamFactory<NameSample, Parameters> {
    protected Muc6NameSampleStreamFactory() {
        super(Parameters.class);
    }

    public static void registerFactory() {
        StreamFactoryRegistry.registerFactory(NameSample.class, "muc6", new Muc6NameSampleStreamFactory());
    }

    @Override
    public ObjectStream<NameSample> create(String[] args) {
        if (args == null) {
            throw new IllegalArgumentException("Passed args must not be null!");
        }
        Parameters params = ArgumentParser.parse(args, Parameters.class);
        if (!params.getData().isDirectory() || !params.getData().exists()) {
            throw new TerminateToolException(-1, "The specified data directory is not valid!");
        }
        TokenizerModel tokenizerModel = (TokenizerModel)new TokenizerModelLoader().load(params.getTokenizerModel());
        ThreadSafeTokenizerME tokenizer = new ThreadSafeTokenizerME(tokenizerModel);
        FileToStringSampleStream mucDocStream = new FileToStringSampleStream(new DirectorySampleStream(params.getData(), file -> StringUtil.toLowerCase(file.getName()).endsWith(".sgm"), false), StandardCharsets.UTF_8);
        return new MucNameSampleStream(tokenizer, mucDocStream);
    }

    public static interface Parameters
    extends BasicFormatParams {
        @ArgumentParser.ParameterDescription(valueName="modelFile")
        public File getTokenizerModel();
    }
}

