/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.postag;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import opennlp.tools.ml.BeamSearch;
import opennlp.tools.ml.model.AbstractModel;
import opennlp.tools.ml.model.MaxentModel;
import opennlp.tools.ml.model.SequenceClassificationModel;
import opennlp.tools.postag.POSTaggerFactory;
import opennlp.tools.util.BaseToolFactory;
import opennlp.tools.util.InvalidFormatException;
import opennlp.tools.util.model.ArtifactSerializer;
import opennlp.tools.util.model.BaseModel;
import opennlp.tools.util.model.ByteArraySerializer;
import opennlp.tools.util.model.POSModelSerializer;
import opennlp.tools.util.model.SerializableArtifact;

public final class POSModel
extends BaseModel
implements SerializableArtifact {
    private static final long serialVersionUID = -6014331858195322339L;
    private static final String COMPONENT_NAME = "POSTaggerME";
    static final String POS_MODEL_ENTRY_NAME = "pos.model";
    static final String GENERATOR_DESCRIPTOR_ENTRY_NAME = "generator.featuregen";

    public POSModel(String languageCode, SequenceClassificationModel<String> posModel, Map<String, String> manifestInfoEntries, POSTaggerFactory posFactory) {
        super(COMPONENT_NAME, languageCode, manifestInfoEntries, posFactory);
        this.artifactMap.put(POS_MODEL_ENTRY_NAME, Objects.requireNonNull(posModel, "posModel must not be null"));
        this.artifactMap.put(GENERATOR_DESCRIPTOR_ENTRY_NAME, posFactory.getFeatureGenerator());
        this.artifactMap.putAll(posFactory.getResources());
    }

    public POSModel(String languageCode, MaxentModel posModel, Map<String, String> manifestInfoEntries, POSTaggerFactory posFactory) {
        this(languageCode, posModel, 3, manifestInfoEntries, posFactory);
    }

    public POSModel(String languageCode, MaxentModel posModel, int beamSize, Map<String, String> manifestInfoEntries, POSTaggerFactory posFactory) {
        super(COMPONENT_NAME, languageCode, manifestInfoEntries, posFactory);
        Objects.requireNonNull(posModel, "posModel must not be null");
        Properties manifest = (Properties)this.artifactMap.get("manifest.properties");
        manifest.setProperty("BeamSize", Integer.toString(beamSize));
        this.artifactMap.put(POS_MODEL_ENTRY_NAME, posModel);
        this.artifactMap.put(GENERATOR_DESCRIPTOR_ENTRY_NAME, posFactory.getFeatureGenerator());
        this.artifactMap.putAll(posFactory.getResources());
        this.checkArtifactMap();
    }

    public POSModel(InputStream in) throws IOException {
        super(COMPONENT_NAME, in);
    }

    public POSModel(File modelFile) throws IOException {
        super(COMPONENT_NAME, modelFile);
    }

    public POSModel(Path modelPath) throws IOException {
        this(modelPath.toFile());
    }

    public POSModel(URL modelURL) throws IOException {
        super(COMPONENT_NAME, modelURL);
    }

    @Override
    protected Class<? extends BaseToolFactory> getDefaultFactory() {
        return POSTaggerFactory.class;
    }

    @Override
    protected void validateArtifactMap() throws InvalidFormatException {
        super.validateArtifactMap();
        if (!(this.artifactMap.get(POS_MODEL_ENTRY_NAME) instanceof MaxentModel)) {
            throw new InvalidFormatException("POS model is incomplete!");
        }
    }

    @Override
    protected boolean skipEntryForSerialization(Map.Entry<String, Object> entry) {
        return GENERATOR_DESCRIPTOR_ENTRY_NAME.equals(entry.getKey()) && entry.getValue() == null;
    }

    @Deprecated
    public MaxentModel getPosModel() {
        if (this.artifactMap.get(POS_MODEL_ENTRY_NAME) instanceof MaxentModel) {
            return (MaxentModel)this.artifactMap.get(POS_MODEL_ENTRY_NAME);
        }
        return null;
    }

    public SequenceClassificationModel<String> getPosSequenceModel() {
        Properties manifest = (Properties)this.artifactMap.get("manifest.properties");
        if (this.artifactMap.get(POS_MODEL_ENTRY_NAME) instanceof MaxentModel) {
            String beamSizeString = manifest.getProperty("BeamSize");
            int beamSize = 3;
            if (beamSizeString != null) {
                beamSize = Integer.parseInt(beamSizeString);
            }
            return new BeamSearch<String>(beamSize, (MaxentModel)this.artifactMap.get(POS_MODEL_ENTRY_NAME));
        }
        if (this.artifactMap.get(POS_MODEL_ENTRY_NAME) instanceof SequenceClassificationModel) {
            return (SequenceClassificationModel)this.artifactMap.get(POS_MODEL_ENTRY_NAME);
        }
        return null;
    }

    public POSTaggerFactory getFactory() {
        return (POSTaggerFactory)this.toolFactory;
    }

    @Override
    protected void createArtifactSerializers(Map<String, ArtifactSerializer> serializers) {
        super.createArtifactSerializers(serializers);
        serializers.put("featuregen", new ByteArraySerializer());
    }

    public Class<POSModelSerializer> getArtifactSerializerClass() {
        return POSModelSerializer.class;
    }

    public int hashCode() {
        return Objects.hash(this.artifactMap.get("manifest.properties"), this.artifactMap.get(POS_MODEL_ENTRY_NAME), Arrays.hashCode((byte[])this.artifactMap.get(GENERATOR_DESCRIPTOR_ENTRY_NAME)));
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof POSModel) {
            POSModel model = (POSModel)obj;
            Map artifactMapToCheck = model.artifactMap;
            AbstractModel abstractModel = (AbstractModel)artifactMapToCheck.get(POS_MODEL_ENTRY_NAME);
            return this.artifactMap.get("manifest.properties").equals(artifactMapToCheck.get("manifest.properties")) && this.artifactMap.get(POS_MODEL_ENTRY_NAME).equals(abstractModel) && Arrays.equals((byte[])this.artifactMap.get(GENERATOR_DESCRIPTOR_ENTRY_NAME), (byte[])artifactMapToCheck.get(GENERATOR_DESCRIPTOR_ENTRY_NAME));
        }
        return false;
    }
}

