/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.formats.ontonotes;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import opennlp.tools.namefind.NameSample;
import opennlp.tools.tokenize.WhitespaceTokenizer;
import opennlp.tools.util.FilterObjectStream;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.Span;
import opennlp.tools.util.StringUtil;

public class OntoNotesNameSampleStream
extends FilterObjectStream<String, NameSample> {
    private final Map<String, String> tokenConversionMap;
    private final List<NameSample> nameSamples = new LinkedList<NameSample>();

    public OntoNotesNameSampleStream(ObjectStream<String> samples) {
        super(samples);
        HashMap<String, String> tokenConversionMap = new HashMap<String, String>();
        tokenConversionMap.put("-LRB-", "(");
        tokenConversionMap.put("-RRB-", ")");
        tokenConversionMap.put("-LSB-", "[");
        tokenConversionMap.put("-RSB-", "]");
        tokenConversionMap.put("-LCB-", "{");
        tokenConversionMap.put("-RCB-", "}");
        tokenConversionMap.put("-AMP-", "&");
        this.tokenConversionMap = Collections.unmodifiableMap(tokenConversionMap);
    }

    private String convertToken(String token) {
        String cleanedToken;
        StringBuilder convertedToken = new StringBuilder(token);
        int startTagEndIndex = convertedToken.indexOf(">");
        if (token.contains("=\"") && startTagEndIndex != -1) {
            convertedToken.delete(0, startTagEndIndex + 1);
        }
        int endTagBeginIndex = convertedToken.indexOf("<");
        int endTagEndIndex = convertedToken.indexOf(">");
        if (endTagBeginIndex != -1 && endTagEndIndex != -1) {
            convertedToken.delete(endTagBeginIndex, endTagEndIndex + 1);
        }
        if (this.tokenConversionMap.get(cleanedToken = convertedToken.toString()) != null) {
            cleanedToken = this.tokenConversionMap.get(cleanedToken);
        }
        return cleanedToken;
    }

    @Override
    public NameSample read() throws IOException {
        String doc;
        if (this.nameSamples.isEmpty() && (doc = (String)this.samples.read()) != null) {
            String line;
            BufferedReader docIn = new BufferedReader(new StringReader(doc));
            boolean clearAdaptiveData = true;
            while ((line = docIn.readLine()) != null) {
                if (line.startsWith("<DOC")) continue;
                if (line.equals("</DOC>")) break;
                String[] tokens = WhitespaceTokenizer.INSTANCE.tokenize(line);
                LinkedList<Span> entities = new LinkedList<Span>();
                ArrayList<String> cleanedTokens = new ArrayList<String>(tokens.length);
                int tokenIndex = 0;
                int entityBeginIndex = -1;
                String entityType = null;
                boolean insideStartEnmaxTag = false;
                for (String token : tokens) {
                    if (token.startsWith("<ENAMEX")) {
                        insideStartEnmaxTag = true;
                        continue;
                    }
                    if (insideStartEnmaxTag) {
                        String typeBegin = "TYPE=\"";
                        if (token.startsWith(typeBegin)) {
                            int typeEnd = token.indexOf("\"", typeBegin.length());
                            entityType = StringUtil.toLowerCase(token.substring(typeBegin.length(), typeEnd));
                        }
                        if (!token.contains(">")) continue;
                        entityBeginIndex = tokenIndex;
                        insideStartEnmaxTag = false;
                    }
                    if (token.endsWith("</ENAMEX>")) {
                        entities.add(new Span(entityBeginIndex, tokenIndex + 1, entityType));
                        entityBeginIndex = -1;
                    }
                    cleanedTokens.add(this.convertToken(token));
                    ++tokenIndex;
                }
                this.nameSamples.add(new NameSample(cleanedTokens.toArray(new String[0]), entities.toArray(new Span[0]), clearAdaptiveData));
                clearAdaptiveData = false;
            }
        }
        if (!this.nameSamples.isEmpty()) {
            return this.nameSamples.remove(0);
        }
        return null;
    }
}

