/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.formats.masc;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.SAXParser;
import opennlp.tools.formats.masc.MascNamedEntityParser;
import opennlp.tools.formats.masc.MascPennTagParser;
import opennlp.tools.formats.masc.MascSentence;
import opennlp.tools.formats.masc.MascSentenceParser;
import opennlp.tools.formats.masc.MascWord;
import opennlp.tools.formats.masc.MascWordParser;
import opennlp.tools.util.Span;
import opennlp.tools.util.XmlUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class MascDocument {
    private static final Logger logger = LoggerFactory.getLogger(MascDocument.class);
    private final List<MascSentence> sentences;
    private final String pathToFile;
    private Iterator<MascSentence> sentenceIterator;
    private boolean hasPennTags = false;
    private boolean hasNamedEntities = false;

    public MascDocument(String path, List<MascSentence> sentences) {
        this.pathToFile = path;
        this.sentences = sentences;
        this.sentenceIterator = sentences.iterator();
    }

    public static MascDocument parseDocument(String path, InputStream f_primary, InputStream f_seg, InputStream f_penn, InputStream f_s, InputStream f_ne) throws IOException {
        String text = MascDocument.readText(f_primary);
        List<MascWord> words = MascDocument.parseWords(f_seg);
        List<Span> sentenceSpans = MascDocument.parseSentences(f_s);
        List<MascSentence> sentences = MascDocument.combineAnnotations(text, sentenceSpans, words);
        MascDocument doc = new MascDocument(path, sentences);
        if (f_penn != null) {
            doc.addPennTags(MascDocument.parsePennTags(f_penn));
        }
        if (f_ne != null) {
            doc.addNamedEntityTags(MascDocument.parseNamedEntity(f_ne));
        }
        return doc;
    }

    private static String readText(InputStream stream) throws IOException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(stream, StandardCharsets.UTF_8));){
            int read;
            StringBuilder contents = new StringBuilder();
            char[] buffer = new char[8192];
            while ((read = ((Reader)reader).read(buffer, 0, buffer.length)) > 0) {
                contents.append(buffer, 0, read);
            }
            String string = contents.toString();
            return string;
        }
    }

    private static List<MascWord> parseWords(InputStream f_seg) throws IOException {
        try (BufferedInputStream bStream = new BufferedInputStream(f_seg);){
            SAXParser saxParser = XmlUtil.createSaxParser();
            MascWordParser handler = new MascWordParser();
            try {
                saxParser.parse((InputStream)bStream, (DefaultHandler)handler);
            }
            catch (SAXException e) {
                throw new IOException("Could not parse the region annotation file");
            }
            List<MascWord> list = Collections.unmodifiableList(handler.getAnchors());
            return list;
        }
    }

    private static List<Span> parseSentences(InputStream f_s) throws IOException {
        try (BufferedInputStream bStream = new BufferedInputStream(f_s);){
            SAXParser saxParser = XmlUtil.createSaxParser();
            MascSentenceParser handler = new MascSentenceParser();
            try {
                saxParser.parse((InputStream)bStream, (DefaultHandler)handler);
            }
            catch (SAXException e) {
                throw new IOException("Could not parse the sentence annotation file");
            }
            List<Span> anchors = handler.getAnchors();
            ArrayList<Span> filteredAnchors = new ArrayList<Span>();
            for (int i = 0; i < anchors.size() - 1; ++i) {
                if (anchors.get(i).getEnd() >= anchors.get(i + 1).getStart()) continue;
                filteredAnchors.add(anchors.get(i));
            }
            filteredAnchors.add(anchors.get(anchors.size() - 1));
            List<Span> list = Collections.unmodifiableList(filteredAnchors);
            return list;
        }
    }

    private static Map<String, Map<Integer, ?>> parsePennTags(InputStream f_penn) throws IOException {
        HashMap tagsAndBases = new HashMap();
        try (BufferedInputStream bStream = new BufferedInputStream(f_penn);){
            SAXParser saxParser = XmlUtil.createSaxParser();
            MascPennTagParser handler = new MascPennTagParser();
            try {
                saxParser.parse((InputStream)bStream, (DefaultHandler)handler);
            }
            catch (SAXException e) {
                throw new IOException("Could not parse the Penn tag annotation file");
            }
            tagsAndBases.put("tokenToTag", handler.getTags());
            tagsAndBases.put("tokenToBase", handler.getBases());
            tagsAndBases.put("tokenToQuarks", handler.getTokenToQuarks());
            HashMap hashMap = tagsAndBases;
            return hashMap;
        }
    }

    private static Map<String, Map<Integer, ?>> parseNamedEntity(InputStream f_ne) throws IOException {
        try (BufferedInputStream bStream = new BufferedInputStream(f_ne);){
            SAXParser saxParser = XmlUtil.createSaxParser();
            MascNamedEntityParser handler = new MascNamedEntityParser();
            try {
                saxParser.parse((InputStream)bStream, (DefaultHandler)handler);
            }
            catch (SAXException e) {
                throw new IOException("Could not parse the named entity annotation file", e);
            }
            Map<Integer, String> entityIDtoEntityType = handler.getEntityIDtoEntityType();
            Map<Integer, List<Integer>> entityIDsToTokens = handler.getEntityIDsToTokens();
            HashMap results = new HashMap();
            results.put("entityIDtoEntityType", entityIDtoEntityType);
            results.put("entityIDsToTokens", entityIDsToTokens);
            HashMap hashMap = results;
            return hashMap;
        }
    }

    private static List<MascSentence> combineAnnotations(String text, List<Span> sentenceSpans, List<MascWord> words) throws IOException {
        int wordIndex = 0;
        int wordCount = words.size();
        ArrayList<MascSentence> sentences = new ArrayList<MascSentence>();
        for (Span s : sentenceSpans) {
            if (s.getEnd() - s.getStart() <= 0) continue;
            ArrayList<MascWord> quarks = new ArrayList<MascWord>();
            int sentenceStart = s.getStart();
            int sentenceEnd = s.getEnd();
            MascWord nextWord = words.get(wordIndex);
            while (sentenceStart < nextWord.getEnd() && wordIndex > 0) {
                nextWord = words.get(--wordIndex);
            }
            boolean sentenceOver = false;
            while (!sentenceOver && wordIndex < wordCount) {
                nextWord = words.get(wordIndex);
                int nextWordStart = nextWord.getStart();
                int nextWordEnd = nextWord.getEnd();
                if (sentenceEnd > nextWordStart && sentenceStart < nextWordEnd) {
                    quarks.add(nextWord);
                    if (sentenceEnd == nextWordEnd) {
                        sentenceOver = true;
                    }
                    ++wordIndex;
                    continue;
                }
                if (sentenceEnd <= nextWordStart) {
                    sentenceOver = true;
                    continue;
                }
                ++wordIndex;
            }
            if (!sentenceOver && sentences.size() != sentenceSpans.size() - 1) {
                throw new IOException("Sentence ends and word ends do not match.First sentence not completed ends at character: " + sentenceEnd);
            }
            MascSentence sentence = new MascSentence(sentenceStart, sentenceEnd, text, quarks, words);
            sentences.add(sentence);
        }
        return Collections.unmodifiableList(sentences);
    }

    private void addNamedEntityTags(Map<String, Map<Integer, ?>> namedEntities) {
        try {
            Map<Integer, String> entityIDtoEntityType = namedEntities.get("entityIDtoEntityType");
            Map<Integer, List<Integer>> entityIDsToTokens = namedEntities.get("entityIDsToTokens");
            for (MascSentence s : this.sentences) {
                boolean success = s.addNamedEntities(entityIDtoEntityType, entityIDsToTokens);
                if (success) continue;
                logger.warn("Issues occurred in the file:  {}", (Object)this.pathToFile);
            }
            this.hasNamedEntities = true;
        }
        catch (IOException e) {
            logger.error("Failed connecting tokens and named entities. The error occurred in the file: {}", (Object)this.pathToFile, (Object)e);
        }
    }

    private void addPennTags(Map<String, Map<Integer, ?>> tagMaps) throws IOException {
        try {
            Map<Integer, String> tokenToTag = tagMaps.get("tokenToTag");
            Map<Integer, String> tokenToBase = tagMaps.get("tokenToBase");
            Map<Integer, int[]> tokenToQuarks = tagMaps.get("tokenToQuarks");
            for (Map.Entry<Integer, ?> token : tokenToQuarks.entrySet()) {
                if (((int[])token.getValue()).length != 0) continue;
                logger.warn("Token without quarks: {}", (Object)token.getKey());
            }
            HashMap<Integer, int[]> quarkToTokens = new HashMap<Integer, int[]>();
            for (Map.Entry<Integer, ?> tokenAndQuarks : tokenToQuarks.entrySet()) {
                int[] quarks;
                int token = tokenAndQuarks.getKey();
                for (int quark : quarks = (int[])tokenAndQuarks.getValue()) {
                    if (quarkToTokens.containsKey(quark)) {
                        int[] tokens = (int[])quarkToTokens.get(quark);
                        int[] newTokens = new int[tokens.length + 1];
                        newTokens[0] = token;
                        System.arraycopy(tokens, 0, newTokens, 1, tokens.length);
                        logger.warn("One quark belongs to several tokens. f-seg ID: {}.", (Object)quark);
                        logger.warn("The error occurred in file: {}", (Object)this.pathToFile);
                        quarkToTokens.put(quark, newTokens);
                        continue;
                    }
                    quarkToTokens.put(quark, new int[]{token});
                }
            }
            for (MascSentence s : this.sentences) {
                boolean success = s.tokenizePenn(tokenToQuarks, quarkToTokens, tokenToBase, tokenToTag);
                if (success) continue;
                logger.warn("Issues occurred in the file:  {}", (Object)this.pathToFile);
            }
            this.hasPennTags = true;
        }
        catch (Exception e) {
            throw new IOException("Could not attach POS tags to words. " + e.getMessage() + Arrays.toString(e.getStackTrace()));
        }
    }

    public boolean hasPennTags() {
        return this.hasPennTags;
    }

    public boolean hasNamedEntities() {
        return this.hasNamedEntities;
    }

    public MascSentence read() {
        MascSentence next = null;
        if (this.sentenceIterator.hasNext()) {
            next = this.sentenceIterator.next();
        }
        return next;
    }

    public void reset() {
        this.sentenceIterator = this.sentences.iterator();
    }
}

