/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.chunker;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import opennlp.tools.chunker.ChunkSample;
import opennlp.tools.chunker.ChunkSampleSequenceStream;
import opennlp.tools.chunker.Chunker;
import opennlp.tools.chunker.ChunkerContextGenerator;
import opennlp.tools.chunker.ChunkerEventStream;
import opennlp.tools.chunker.ChunkerFactory;
import opennlp.tools.chunker.ChunkerModel;
import opennlp.tools.ml.BeamSearch;
import opennlp.tools.ml.EventTrainer;
import opennlp.tools.ml.SequenceTrainer;
import opennlp.tools.ml.TrainerFactory;
import opennlp.tools.ml.model.MaxentModel;
import opennlp.tools.ml.model.SequenceClassificationModel;
import opennlp.tools.util.DownloadUtil;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.Sequence;
import opennlp.tools.util.SequenceValidator;
import opennlp.tools.util.Span;
import opennlp.tools.util.TokenTag;
import opennlp.tools.util.TrainingParameters;

public class ChunkerME
implements Chunker {
    public static final int DEFAULT_BEAM_SIZE = 10;
    private Sequence bestSequence;
    private final SequenceClassificationModel<TokenTag> model;
    private final ChunkerContextGenerator contextGenerator;
    private final SequenceValidator<TokenTag> sequenceValidator;

    public ChunkerME(String language) throws IOException {
        this(DownloadUtil.downloadModel(language, DownloadUtil.ModelType.CHUNKER, ChunkerModel.class));
    }

    public ChunkerME(ChunkerModel model) {
        this.contextGenerator = model.getFactory().getContextGenerator();
        this.sequenceValidator = model.getFactory().getSequenceValidator();
        this.model = model.getChunkerSequenceModel() != null ? model.getChunkerSequenceModel() : new BeamSearch<TokenTag>(10, model.getChunkerModel(), 0);
    }

    @Override
    public String[] chunk(String[] toks, String[] tags) {
        TokenTag[] tuples = TokenTag.create(toks, tags);
        this.bestSequence = this.model.bestSequence((TokenTag[])tuples, new Object[0], this.contextGenerator, this.sequenceValidator);
        List<String> c = this.bestSequence.getOutcomes();
        return c.toArray(new String[0]);
    }

    @Override
    public Span[] chunkAsSpans(String[] toks, String[] tags) {
        String[] preds = this.chunk(toks, tags);
        return ChunkSample.phrasesAsSpanList(toks, tags, preds);
    }

    @Override
    public Sequence[] topKSequences(String[] sentence, String[] tags) {
        TokenTag[] tuples = TokenTag.create(sentence, tags);
        return this.model.bestSequences(10, (TokenTag[])tuples, new Object[0], this.contextGenerator, this.sequenceValidator);
    }

    @Override
    public Sequence[] topKSequences(String[] sentence, String[] tags, double minSequenceScore) {
        TokenTag[] tuples = TokenTag.create(sentence, tags);
        return this.model.bestSequences(10, (TokenTag[])tuples, new Object[0], minSequenceScore, this.contextGenerator, this.sequenceValidator);
    }

    public void probs(double[] probs) {
        this.bestSequence.getProbs(probs);
    }

    public double[] probs() {
        return this.bestSequence.getProbs();
    }

    public static ChunkerModel train(String lang, ObjectStream<ChunkSample> in, TrainingParameters mlParams, ChunkerFactory factory) throws IOException {
        int beamSize = mlParams.getIntParameter("BeamSize", 10);
        HashMap<String, String> manifestInfoEntries = new HashMap<String, String>();
        TrainerFactory.TrainerType trainerType = TrainerFactory.getTrainerType(mlParams);
        MaxentModel chunkerModel = null;
        SequenceClassificationModel<String> seqChunkerModel = null;
        if (TrainerFactory.TrainerType.EVENT_MODEL_TRAINER.equals((Object)trainerType)) {
            ChunkerEventStream es = new ChunkerEventStream(in, factory.getContextGenerator());
            EventTrainer trainer = TrainerFactory.getEventTrainer(mlParams, manifestInfoEntries);
            chunkerModel = trainer.train(es);
        } else if (TrainerFactory.TrainerType.SEQUENCE_TRAINER.equals((Object)trainerType)) {
            SequenceTrainer trainer = TrainerFactory.getSequenceModelTrainer(mlParams, manifestInfoEntries);
            ChunkSampleSequenceStream ss = new ChunkSampleSequenceStream(in, factory.getContextGenerator());
            seqChunkerModel = trainer.train(ss);
        } else {
            throw new IllegalArgumentException("Trainer type is not supported: " + trainerType);
        }
        if (chunkerModel != null) {
            return new ChunkerModel(lang, chunkerModel, beamSize, manifestInfoEntries, factory);
        }
        return new ChunkerModel(lang, seqChunkerModel, manifestInfoEntries, factory);
    }
}

