/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.release.phase;

import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Settings;
import org.apache.maven.shared.release.ReleaseExecutionException;
import org.apache.maven.shared.release.ReleaseFailureException;
import org.apache.maven.shared.release.ReleaseResult;
import org.apache.maven.shared.release.config.ReleaseDescriptor;
import org.apache.maven.shared.release.env.DefaultReleaseEnvironment;
import org.apache.maven.shared.release.phase.ReleasePhase;
import org.codehaus.plexus.logging.AbstractLogEnabled;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractReleasePhase
extends AbstractLogEnabled
implements ReleasePhase {
    protected ResourceBundle getResourceBundle(Locale locale) {
        return ResourceBundle.getBundle("release-messages", locale, AbstractReleasePhase.class.getClassLoader());
    }

    @Override
    public ReleaseResult clean(List<MavenProject> reactorProjects) {
        return this.getReleaseResultSuccess();
    }

    @Override
    public ReleaseResult execute(ReleaseDescriptor releaseDescriptor, Settings settings, List<MavenProject> reactorProjects) throws ReleaseExecutionException, ReleaseFailureException {
        return this.execute(releaseDescriptor, new DefaultReleaseEnvironment().setSettings(settings), reactorProjects);
    }

    @Override
    public ReleaseResult simulate(ReleaseDescriptor releaseDescriptor, Settings settings, List<MavenProject> reactorProjects) throws ReleaseExecutionException, ReleaseFailureException {
        return this.simulate(releaseDescriptor, new DefaultReleaseEnvironment().setSettings(settings), reactorProjects);
    }

    protected void logInfo(ReleaseResult result, String message) {
        result.appendInfo(message);
        this.getLogger().info(message);
    }

    protected void logWarn(ReleaseResult result, String message) {
        result.appendWarn(message);
        this.getLogger().warn(message);
    }

    protected void logError(ReleaseResult result, String message) {
        result.appendWarn(message);
        this.getLogger().error(message);
    }

    protected void logDebug(ReleaseResult result, String message) {
        result.appendDebug(message);
        this.getLogger().debug(message);
    }

    protected void logDebug(ReleaseResult result, String message, Exception e) {
        result.appendDebug(message, e);
        this.getLogger().debug(message, (Throwable)e);
    }

    protected ReleaseResult getReleaseResultSuccess() {
        ReleaseResult result = new ReleaseResult();
        result.setResultCode(0);
        return result;
    }
}

