/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.jdbc.hive.strategy.zk;

import java.util.List;
import org.apache.kyuubi.jdbc.hive.strategy.ServerSelectStrategy;
import org.apache.kyuubi.shaded.curator.RetryPolicy;
import org.apache.kyuubi.shaded.curator.framework.CuratorFramework;
import org.apache.kyuubi.shaded.curator.framework.recipes.atomic.AtomicValue;
import org.apache.kyuubi.shaded.curator.framework.recipes.atomic.DistributedAtomicInteger;
import org.apache.kyuubi.shaded.curator.retry.RetryForever;

public class PollingSelectStrategy
implements ServerSelectStrategy {
    public static final String strategyName = "polling";
    private static final String COUNTER_PATH_PREFIX = "/";
    private static final String COUNTER_PATH_SUFFIX = "-counter";

    @Override
    public String chooseServer(List<String> serverHosts, CuratorFramework zkClient, String namespace) {
        String counterPath = COUNTER_PATH_PREFIX + namespace + COUNTER_PATH_SUFFIX;
        try {
            return serverHosts.get(this.getAndIncrement(zkClient, counterPath) % serverHosts.size());
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to choose server by polling select strategy", e);
        }
    }

    private int getAndIncrement(CuratorFramework zkClient, String path) throws Exception {
        AtomicValue atomicVal;
        DistributedAtomicInteger dai = new DistributedAtomicInteger(zkClient, path, (RetryPolicy)new RetryForever(3000));
        while ((atomicVal = dai.add(Integer.valueOf(1))) == null || !atomicVal.succeeded()) {
        }
        return (Integer)atomicVal.preValue();
    }
}

