/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.jdbc.hive;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class JdbcConnectionParams {
    static final String CLIENT_PROTOCOL_VERSION = "clientProtocolVersion";
    static final String RETRIES = "retries";
    public static final String AUTH_TYPE = "auth";
    public static final String AUTH_QOP_DEPRECATED = "sasl.qop";
    public static final String AUTH_QOP = "saslQop";
    public static final String AUTH_SIMPLE = "noSasl";
    public static final String AUTH_USER = "user";
    public static final String AUTH_PRINCIPAL = "principal";
    public static final String AUTH_KYUUBI_SERVER_PRINCIPAL = "kyuubiServerPrincipal";
    public static final String AUTH_KYUUBI_CLIENT_PRINCIPAL = "kyuubiClientPrincipal";
    public static final String AUTH_KYUUBI_CLIENT_KEYTAB = "kyuubiClientKeytab";
    public static final String AUTH_KYUUBI_CLIENT_TICKET_CACHE = "kyuubiClientTicketCache";
    public static final String AUTH_PASSWD = "password";
    public static final String AUTH_KERBEROS_AUTH_TYPE = "kerberosAuthType";
    public static final String AUTH_KERBEROS_AUTH_TYPE_FROM_KEYTAB = "fromKeytab";
    public static final String AUTH_KERBEROS_AUTH_TYPE_FROM_SUBJECT = "fromSubject";
    public static final String AUTH_KERBEROS_AUTH_TYPE_FROM_TICKET_CACHE = "fromTicketCache";
    public static final String AUTH_TYPE_JWT = "jwt";
    public static final String AUTH_TYPE_JWT_KEY = "jwt";
    public static final String AUTH_JWT_ENV = "JWT";
    public static final String ANONYMOUS_USER = "anonymous";
    public static final String ANONYMOUS_PASSWD = "anonymous";
    public static final String USE_SSL = "ssl";
    public static final String SSL_TRUST_STORE = "sslTrustStore";
    public static final String SSL_TRUST_STORE_PASSWORD = "trustStorePassword";
    static final String TRANSPORT_MODE_DEPRECATED = "hive.server2.transport.mode";
    public static final String TRANSPORT_MODE = "transportMode";
    static final String HTTP_PATH_DEPRECATED = "hive.server2.thrift.http.path";
    public static final String HTTP_PATH = "httpPath";
    public static final String SERVICE_DISCOVERY_MODE = "serviceDiscoveryMode";
    public static final String PROPERTY_DRIVER = "driver";
    public static final String PROPERTY_URL = "url";
    static final String SERVICE_DISCOVERY_MODE_NONE = "none";
    static final String SERVICE_DISCOVERY_MODE_ZOOKEEPER = "zooKeeper";
    static final String ZOOKEEPER_NAMESPACE = "zooKeeperNamespace";
    static final String SERVER_SELECT_STRATEGY = "serverSelectStrategy";
    static final String ZOOKEEPER_DEFAULT_NAMESPACE = "hiveserver2";
    static final String COOKIE_AUTH = "cookieAuth";
    static final String COOKIE_NAME = "cookieName";
    static final String DEFAULT_COOKIE_NAMES_HS2 = "hive.server2.auth";
    static final String HTTP_HEADER_PREFIX = "http.header.";
    static final String FETCH_SIZE = "fetchSize";
    static final String INIT_FILE = "initFile";
    static final String WM_POOL = "wmPool";
    static final String HTTP_COOKIE_PREFIX = "http.cookie.";
    static final String CONNECT_TIMEOUT = "connectTimeout";
    static final String SOCKET_TIMEOUT = "socketTimeout";
    static final String THRIFT_CLIENT_MAX_MESSAGE_SIZE = "thrift.client.max.message.size";
    static final String[] APPLICATION = new String[]{"applicationName", "ApplicationName"};
    static final String USE_TWO_WAY_SSL = "twoWay";
    static final String TRUE = "true";
    static final String SSL_KEY_STORE = "sslKeyStore";
    static final String SSL_KEY_STORE_PASSWORD = "keyStorePassword";
    static final String SSL_KEY_STORE_TYPE = "JKS";
    static final String SUNX509_ALGORITHM_STRING = "SunX509";
    static final String SUNJSSE_ALGORITHM_STRING = "SunJSSE";
    static final String SSL_TRUST_STORE_TYPE = "JKS";
    static final String SSL_STORE_PASSWORD_PATH = "storePasswordPath";
    static final String HIVE_VAR_PREFIX = "hivevar:";
    static final String HIVE_CONF_PREFIX = "hiveconf:";
    private String host = null;
    private int port = 0;
    private String jdbcUriString;
    private String catalogName;
    private String dbName = "default";
    private Map<String, String> hiveConfs = new LinkedHashMap<String, String>();
    private Map<String, String> hiveVars = new LinkedHashMap<String, String>();
    private Map<String, String> sessionVars = new LinkedHashMap<String, String>();
    private String suppliedURLAuthority;
    private String zooKeeperEnsemble = null;
    private String currentHostZnodePath;
    private final List<String> rejectedHostZnodePaths = new ArrayList<String>();

    public JdbcConnectionParams() {
    }

    public JdbcConnectionParams(JdbcConnectionParams params) {
        this.host = params.host;
        this.port = params.port;
        this.jdbcUriString = params.jdbcUriString;
        this.catalogName = params.catalogName;
        this.dbName = params.dbName;
        this.hiveConfs.putAll(params.hiveConfs);
        this.hiveVars.putAll(params.hiveVars);
        this.sessionVars.putAll(params.sessionVars);
        this.suppliedURLAuthority = params.suppliedURLAuthority;
        this.zooKeeperEnsemble = params.zooKeeperEnsemble;
        this.currentHostZnodePath = params.currentHostZnodePath;
        this.rejectedHostZnodePaths.addAll(params.rejectedHostZnodePaths);
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getJdbcUriString() {
        return this.jdbcUriString;
    }

    public String getCatalogName() {
        return this.catalogName;
    }

    public String getDbName() {
        return this.dbName;
    }

    public Map<String, String> getHiveConfs() {
        return this.hiveConfs;
    }

    public Map<String, String> getHiveVars() {
        return this.hiveVars;
    }

    public Map<String, String> getSessionVars() {
        return this.sessionVars;
    }

    public String getSuppliedURLAuthority() {
        return this.suppliedURLAuthority;
    }

    public String getZooKeeperEnsemble() {
        return this.zooKeeperEnsemble;
    }

    public List<String> getRejectedHostZnodePaths() {
        return this.rejectedHostZnodePaths;
    }

    public String getCurrentHostZnodePath() {
        return this.currentHostZnodePath;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setJdbcUriString(String jdbcUriString) {
        this.jdbcUriString = jdbcUriString;
    }

    public void setCatalogName(String catalogName) {
        this.catalogName = catalogName;
    }

    public void setDbName(String dbName) {
        this.dbName = dbName;
    }

    public void setHiveConfs(Map<String, String> hiveConfs) {
        this.hiveConfs = hiveConfs;
    }

    public void setHiveVars(Map<String, String> hiveVars) {
        this.hiveVars = hiveVars;
    }

    public void setSessionVars(Map<String, String> sessionVars) {
        this.sessionVars = sessionVars;
    }

    public void setSuppliedURLAuthority(String suppliedURLAuthority) {
        this.suppliedURLAuthority = suppliedURLAuthority;
    }

    public void setZooKeeperEnsemble(String zooKeeperEnsemble) {
        this.zooKeeperEnsemble = zooKeeperEnsemble;
    }

    public void setCurrentHostZnodePath(String currentHostZnodePath) {
        this.currentHostZnodePath = currentHostZnodePath;
    }
}

