/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.util.Properties;
import joptsimple.OptionException;
import kafka.admin.ConsumerGroupCommand;
import kafka.admin.ConsumerGroupCommandTest;
import kafka.server.KafkaBroker;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.errors.GroupIdNotFoundException;
import org.apache.kafka.common.errors.GroupNotEmptyException;
import org.apache.kafka.common.protocol.Errors;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.;
import scala.$less$colon$less$;
import scala.Console$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Set;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\u00113A!\u0004\b\u0001'!)\u0001\u0004\u0001C\u00013!)1\u0004\u0001C\u00019!)\u0001\u0007\u0001C\u00019!)!\u0007\u0001C\u00019!)A\u0007\u0001C\u00019!)a\u0007\u0001C\u00019!)\u0001\b\u0001C\u00019!)!\b\u0001C\u00019!)A\b\u0001C\u00019!)a\b\u0001C\u00019!)\u0001\t\u0001C\u00019!)!\t\u0001C\u00019\tAB)\u001a7fi\u0016\u001cuN\\:v[\u0016\u0014xI]8vaN$Vm\u001d;\u000b\u0005=\u0001\u0012!B1e[&t'\"A\t\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001\u0001\u0006\t\u0003+Yi\u0011AD\u0005\u0003/9\u0011\u0001dQ8ogVlWM]$s_V\u00048i\\7nC:$G+Z:u\u0003\u0019a\u0014N\\5u}Q\t!\u0004\u0005\u0002\u0016\u0001\u0005IB/Z:u\t\u0016dW\r^3XSRDGk\u001c9jG>\u0003H/[8o)\u0005i\u0002C\u0001\u0010\"\u001b\u0005y\"\"\u0001\u0011\u0002\u000bM\u001c\u0017\r\\1\n\u0005\tz\"\u0001B+oSRD#A\u0001\u0013\u0011\u0005\u0015rS\"\u0001\u0014\u000b\u0005\u001dB\u0013aA1qS*\u0011\u0011FK\u0001\bUV\u0004\u0018\u000e^3s\u0015\tYC&A\u0003kk:LGOC\u0001.\u0003\ry'oZ\u0005\u0003_\u0019\u0012A\u0001V3ti\u0006iB/Z:u\t\u0016dW\r^3D[\u0012tuN\\#ySN$\u0018N\\4He>,\b\u000f\u000b\u0002\u0004I\u0005QB/Z:u\t\u0016dW\r^3O_:,\u00050[:uS:<wI]8va\"\u0012A\u0001J\u0001\u001bi\u0016\u001cH\u000fR3mKR,7)\u001c3O_:,U\u000e\u001d;z\u000fJ|W\u000f\u001d\u0015\u0003\u000b\u0011\nq\u0003^3ti\u0012+G.\u001a;f\u001d>tW)\u001c9us\u001e\u0013x.\u001e9)\u0005\u0019!\u0013a\u0006;fgR$U\r\\3uK\u000ekG-R7qif<%o\\;qQ\t9A%\u0001\fuKN$H)\u001a7fi\u0016\u001cU\u000eZ!mY\u001e\u0013x.\u001e9tQ\tAA%\u0001\u000buKN$H)\u001a7fi\u0016,U\u000e\u001d;z\u000fJ|W\u000f\u001d\u0015\u0003\u0013\u0011\nQ\u0005^3ti\u0012+G.\u001a;f\u00076$w+\u001b;i\u001b&DxJZ*vG\u000e,7o]!oI\u0016\u0013(o\u001c:)\u0005)!\u0013A\t;fgR$U\r\\3uK^KG\u000f['jq>37+^2dKN\u001c\u0018I\u001c3FeJ|'\u000f\u000b\u0002\fI\u0005YC/Z:u\t\u0016dW\r^3XSRDWK\u001c:fG><g.\u001b>fI:+woQ8ogVlWM](qi&|g\u000e\u000b\u0002\rI\u0001")
public class DeleteConsumerGroupsTest
extends ConsumerGroupCommandTest {
    @Test
    public void testDeleteWithTopicOption() {
        TestUtils$.MODULE$.createOffsetsTopic(this.zkClient(), (Seq<KafkaBroker>)this.servers());
        String[] cgcArgs = new String[]{"--bootstrap-server", this.bootstrapServers(this.bootstrapServers$default$1()), "--delete", "--group", this.group(), "--topic"};
        Assertions.assertThrows(OptionException.class, () -> this.getConsumerGroupService(cgcArgs));
    }

    @Test
    public void testDeleteCmdNonExistingGroup() {
        TestUtils$.MODULE$.createOffsetsTopic(this.zkClient(), (Seq<KafkaBroker>)this.servers());
        String missingGroup = "missing.group";
        String[] cgcArgs = new String[]{"--bootstrap-server", this.bootstrapServers(this.bootstrapServers$default$1()), "--delete", "--group", missingGroup};
        ConsumerGroupCommand.ConsumerGroupService service = this.getConsumerGroupService(cgcArgs);
        JFunction0.mcV.sp & Serializable grabConsoleOutput_f = (JFunction0.mcV.sp & Serializable)() -> service.deleteGroups();
        ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
        try {
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        Object var5_4 = null;
        Object var6_5 = null;
        String output = grabConsoleOutput_out.toString();
        Assertions.assertTrue((output.contains(new StringBuilder(37).append("Group '").append(missingGroup).append("' could not be deleted due to:").toString()) && output.contains(Errors.GROUP_ID_NOT_FOUND.message()) ? 1 : 0) != 0, (String)new StringBuilder(68).append("The expected error (").append(Errors.GROUP_ID_NOT_FOUND).append(") was not detected while deleting consumer group").toString());
    }

    @Test
    public void testDeleteNonExistingGroup() {
        TestUtils$.MODULE$.createOffsetsTopic(this.zkClient(), (Seq<KafkaBroker>)this.servers());
        String missingGroup = "missing.group";
        String[] cgcArgs = new String[]{"--bootstrap-server", this.bootstrapServers(this.bootstrapServers$default$1()), "--delete", "--group", missingGroup};
        Map result = this.getConsumerGroupService(cgcArgs).deleteGroups();
        Assertions.assertTrue((result.size() == 1 && result.keySet().contains((Object)missingGroup) && ((Throwable)result.apply((Object)missingGroup)).getCause() instanceof GroupIdNotFoundException ? 1 : 0) != 0, (String)new StringBuilder(68).append("The expected error (").append(Errors.GROUP_ID_NOT_FOUND).append(") was not detected while deleting consumer group").toString());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDeleteCmdNonEmptyGroup() {
        TestUtils$.MODULE$.createOffsetsTopic(this.zkClient(), (Seq<KafkaBroker>)this.servers());
        this.addConsumerGroupExecutor(1, this.addConsumerGroupExecutor$default$2(), this.addConsumerGroupExecutor$default$3(), this.addConsumerGroupExecutor$default$4(), this.addConsumerGroupExecutor$default$5(), this.addConsumerGroupExecutor$default$6());
        String[] cgcArgs = new String[]{"--bootstrap-server", this.bootstrapServers(this.bootstrapServers$default$1()), "--delete", "--group", this.group()};
        ConsumerGroupCommand.ConsumerGroupService service = this.getConsumerGroupService(cgcArgs);
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!DeleteConsumerGroupsTest.$anonfun$testDeleteCmdNonEmptyGroup$1(this, service)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"The group did not initialize as expected.");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        JFunction0.mcV.sp & Serializable grabConsoleOutput_f = (JFunction0.mcV.sp & Serializable)() -> service.deleteGroups();
        ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
        try {
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        Object var10_6 = null;
        Object var11_7 = null;
        String output = grabConsoleOutput_out.toString();
        Assertions.assertTrue((output.contains(new StringBuilder(37).append("Group '").append(this.group()).append("' could not be deleted due to:").toString()) && output.contains(Errors.NON_EMPTY_GROUP.message()) ? 1 : 0) != 0, (String)new StringBuilder(84).append("The expected error (").append(Errors.NON_EMPTY_GROUP).append(") was not detected while deleting consumer group. Output was: (").append(output).append(")").toString());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDeleteNonEmptyGroup() {
        TestUtils$.MODULE$.createOffsetsTopic(this.zkClient(), (Seq<KafkaBroker>)this.servers());
        this.addConsumerGroupExecutor(1, this.addConsumerGroupExecutor$default$2(), this.addConsumerGroupExecutor$default$3(), this.addConsumerGroupExecutor$default$4(), this.addConsumerGroupExecutor$default$5(), this.addConsumerGroupExecutor$default$6());
        String[] cgcArgs = new String[]{"--bootstrap-server", this.bootstrapServers(this.bootstrapServers$default$1()), "--delete", "--group", this.group()};
        ConsumerGroupCommand.ConsumerGroupService service = this.getConsumerGroupService(cgcArgs);
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!DeleteConsumerGroupsTest.$anonfun$testDeleteNonEmptyGroup$1(this, service)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"The group did not initialize as expected.");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Map result = service.deleteGroups();
        Assertions.assertNotNull((Object)result.apply((Object)this.group()), (String)new StringBuilder(73).append("Group was deleted successfully, but it shouldn't have been. Result was:(").append(result).append(")").toString());
        Assertions.assertTrue((result.size() == 1 && result.keySet().contains((Object)this.group()) && ((Throwable)result.apply((Object)this.group())).getCause() instanceof GroupNotEmptyException ? 1 : 0) != 0, (String)new StringBuilder(83).append("The expected error (").append(Errors.NON_EMPTY_GROUP).append(") was not detected while deleting consumer group. Result was:(").append(result).append(")").toString());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDeleteCmdEmptyGroup() {
        TestUtils$.MODULE$.createOffsetsTopic(this.zkClient(), (Seq<KafkaBroker>)this.servers());
        ConsumerGroupCommandTest.ConsumerGroupExecutor executor = this.addConsumerGroupExecutor(1, this.addConsumerGroupExecutor$default$2(), this.addConsumerGroupExecutor$default$3(), this.addConsumerGroupExecutor$default$4(), this.addConsumerGroupExecutor$default$5(), this.addConsumerGroupExecutor$default$6());
        String[] cgcArgs = new String[]{"--bootstrap-server", this.bootstrapServers(this.bootstrapServers$default$1()), "--delete", "--group", this.group()};
        ConsumerGroupCommand.ConsumerGroupService service = this.getConsumerGroupService(cgcArgs);
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!DeleteConsumerGroupsTest.$anonfun$testDeleteCmdEmptyGroup$1(this, service)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"The group did not initialize as expected.");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        executor.shutdown();
        long l2 = 100L;
        long waitUntilTrue_waitTimeMs2 = 15000L;
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!DeleteConsumerGroupsTest.$anonfun$testDeleteCmdEmptyGroup$3(this, service)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                Assertions.fail((String)"The group did not become empty as expected.");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
        }
        JFunction0.mcV.sp & Serializable grabConsoleOutput_f = (JFunction0.mcV.sp & Serializable)() -> service.deleteGroups();
        ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
        try {
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        Object var16_10 = null;
        Object var17_11 = null;
        Assertions.assertTrue((boolean)grabConsoleOutput_out.toString().contains(new StringBuilder(58).append("Deletion of requested consumer groups ('").append(this.group()).append("') was successful.").toString()), (String)"The consumer group could not be deleted as expected");
    }

    /*
     * Unable to fully structure code
     */
    @Test
    public void testDeleteCmdAllGroups() {
        TestUtils$.MODULE$.createOffsetsTopic(this.zkClient(), (Seq<KafkaBroker>)this.servers());
        groups = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 3).map((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$testDeleteCmdAllGroups$1$adapted(kafka.admin.DeleteConsumerGroupsTest java.lang.Object ), (Ljava/lang/Object;)Lscala/Tuple2;)((DeleteConsumerGroupsTest)this)).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        cgcArgs = new String[]{"--bootstrap-server", this.bootstrapServers(this.bootstrapServers$default$1()), "--delete", "--all-groups"};
        service = this.getConsumerGroupService(cgcArgs);
        var9_4 = 100L;
        waitUntilTrue_waitTimeMs = 15000L;
        waitUntilTrue_startTime = System.currentTimeMillis();
        while (!DeleteConsumerGroupsTest.$anonfun$testDeleteCmdAllGroups$2(service, groups)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"The group did not initialize as expected.");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        groups.values().foreach((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$testDeleteCmdAllGroups$5$adapted(kafka.admin.ConsumerGroupCommandTest$ConsumerGroupExecutor ), (Lkafka/admin/ConsumerGroupCommandTest$ConsumerGroupExecutor;)Ljava/lang/Object;)());
        var15_7 = 100L;
        waitUntilTrue_waitTimeMs = 15000L;
        waitUntilTrue_startTime = System.currentTimeMillis();
        while (!DeleteConsumerGroupsTest.$anonfun$testDeleteCmdAllGroups$6(groups, service)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"The group did not become empty as expected.");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        grabConsoleOutput_f = (JFunction0.mcV.sp & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()V, $anonfun$testDeleteCmdAllGroups$9(kafka.admin.ConsumerGroupCommand$ConsumerGroupService ), ()V)((ConsumerGroupCommand.ConsumerGroupService)service);
        grabConsoleOutput_out = new ByteArrayOutputStream();
        try {
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        var19_10 = null;
        var20_11 = null;
        output = grabConsoleOutput_out.toString().trim();
        expectedGroupsForDeletion = groups.keySet();
        deletedGroupsGrepped = Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])StringOps$.MODULE$.split$extension(Predef$.MODULE$.augmentString(output.substring(output.indexOf(40) + 1, output.indexOf(41))), ',')), (Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$testDeleteCmdAllGroups$10(java.lang.String ), (Ljava/lang/String;)Ljava/lang/String;)(), ClassTag$.MODULE$.apply(String.class))).toSet();
        if (!output.matches("Deletion of requested consumer groups (.*) was successful.")) ** GOTO lbl-1000
        v0 = deletedGroupsGrepped;
        if (!(v0 != null ? v0.equals(expectedGroupsForDeletion) == false : expectedGroupsForDeletion != null)) {
            v1 = true;
        } else lbl-1000:
        // 2 sources

        {
            v1 = false;
        }
        Assertions.assertTrue((boolean)v1, (String)"The consumer group(s) could not be deleted as expected");
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDeleteEmptyGroup() {
        TestUtils$.MODULE$.createOffsetsTopic(this.zkClient(), (Seq<KafkaBroker>)this.servers());
        ConsumerGroupCommandTest.ConsumerGroupExecutor executor = this.addConsumerGroupExecutor(1, this.addConsumerGroupExecutor$default$2(), this.addConsumerGroupExecutor$default$3(), this.addConsumerGroupExecutor$default$4(), this.addConsumerGroupExecutor$default$5(), this.addConsumerGroupExecutor$default$6());
        String[] cgcArgs = new String[]{"--bootstrap-server", this.bootstrapServers(this.bootstrapServers$default$1()), "--delete", "--group", this.group()};
        ConsumerGroupCommand.ConsumerGroupService service = this.getConsumerGroupService(cgcArgs);
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!DeleteConsumerGroupsTest.$anonfun$testDeleteEmptyGroup$1(this, service)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"The group did not initialize as expected.");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        executor.shutdown();
        long l2 = 100L;
        long waitUntilTrue_waitTimeMs2 = 15000L;
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!DeleteConsumerGroupsTest.$anonfun$testDeleteEmptyGroup$3(this, service)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                Assertions.fail((String)"The group did not become empty as expected.");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
        }
        Map result = service.deleteGroups();
        Assertions.assertTrue((result.size() == 1 && result.keySet().contains((Object)this.group()) && result.apply((Object)this.group()) == null ? 1 : 0) != 0, (String)"The consumer group could not be deleted as expected");
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDeleteCmdWithMixOfSuccessAndError() {
        TestUtils$.MODULE$.createOffsetsTopic(this.zkClient(), (Seq<KafkaBroker>)this.servers());
        String missingGroup = "missing.group";
        ConsumerGroupCommandTest.ConsumerGroupExecutor executor = this.addConsumerGroupExecutor(1, this.addConsumerGroupExecutor$default$2(), this.addConsumerGroupExecutor$default$3(), this.addConsumerGroupExecutor$default$4(), this.addConsumerGroupExecutor$default$5(), this.addConsumerGroupExecutor$default$6());
        Object[] cgcArgs = new String[]{"--bootstrap-server", this.bootstrapServers(this.bootstrapServers$default$1()), "--delete", "--group", this.group()};
        ConsumerGroupCommand.ConsumerGroupService service = this.getConsumerGroupService((String[])cgcArgs);
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!DeleteConsumerGroupsTest.$anonfun$testDeleteCmdWithMixOfSuccessAndError$1(this, service)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"The group did not initialize as expected.");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        executor.shutdown();
        long l2 = 100L;
        long waitUntilTrue_waitTimeMs2 = 15000L;
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!DeleteConsumerGroupsTest.$anonfun$testDeleteCmdWithMixOfSuccessAndError$3(this, service)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                Assertions.fail((String)"The group did not become empty as expected.");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
        }
        ConsumerGroupCommand.ConsumerGroupService service2 = this.getConsumerGroupService((String[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.refArrayOps(cgcArgs), (Object)new String[]{"--group", missingGroup}, ClassTag$.MODULE$.apply(String.class)));
        JFunction0.mcV.sp & Serializable grabConsoleOutput_f = (JFunction0.mcV.sp & Serializable)() -> service2.deleteGroups();
        ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
        try {
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        Object var19_12 = null;
        Object var20_13 = null;
        String output = grabConsoleOutput_out.toString();
        Assertions.assertTrue((output.contains(new StringBuilder(37).append("Group '").append(missingGroup).append("' could not be deleted due to:").toString()) && output.contains(Errors.GROUP_ID_NOT_FOUND.message()) && output.contains(new StringBuilder(51).append("These consumer groups were deleted successfully: '").append(this.group()).append("'").toString()) ? 1 : 0) != 0, (String)"The consumer group deletion did not work as expected");
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDeleteWithMixOfSuccessAndError() {
        TestUtils$.MODULE$.createOffsetsTopic(this.zkClient(), (Seq<KafkaBroker>)this.servers());
        String missingGroup = "missing.group";
        ConsumerGroupCommandTest.ConsumerGroupExecutor executor = this.addConsumerGroupExecutor(1, this.addConsumerGroupExecutor$default$2(), this.addConsumerGroupExecutor$default$3(), this.addConsumerGroupExecutor$default$4(), this.addConsumerGroupExecutor$default$5(), this.addConsumerGroupExecutor$default$6());
        Object[] cgcArgs = new String[]{"--bootstrap-server", this.bootstrapServers(this.bootstrapServers$default$1()), "--delete", "--group", this.group()};
        ConsumerGroupCommand.ConsumerGroupService service = this.getConsumerGroupService((String[])cgcArgs);
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!DeleteConsumerGroupsTest.$anonfun$testDeleteWithMixOfSuccessAndError$1(this, service)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"The group did not initialize as expected.");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        executor.shutdown();
        long l2 = 100L;
        long waitUntilTrue_waitTimeMs2 = 15000L;
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!DeleteConsumerGroupsTest.$anonfun$testDeleteWithMixOfSuccessAndError$3(this, service)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                Assertions.fail((String)"The group did not become empty as expected.");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
        }
        Map result = this.getConsumerGroupService((String[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.refArrayOps(cgcArgs), (Object)new String[]{"--group", missingGroup}, ClassTag$.MODULE$.apply(String.class))).deleteGroups();
        Assertions.assertTrue((result.size() == 2 && result.keySet().contains((Object)this.group()) && result.apply((Object)this.group()) == null && result.keySet().contains((Object)missingGroup) && ((Throwable)result.apply((Object)missingGroup)).getMessage().contains(Errors.GROUP_ID_NOT_FOUND.message()) ? 1 : 0) != 0, (String)"The consumer group deletion did not work as expected");
    }

    @Test
    public void testDeleteWithUnrecognizedNewConsumerOption() {
        String[] cgcArgs = new String[]{"--new-consumer", "--bootstrap-server", this.bootstrapServers(this.bootstrapServers$default$1()), "--delete", "--group", this.group()};
        Assertions.assertThrows(OptionException.class, () -> this.getConsumerGroupService(cgcArgs));
    }

    public static final /* synthetic */ boolean $anonfun$testDeleteCmdNonEmptyGroup$1(DeleteConsumerGroupsTest $this, ConsumerGroupCommand.ConsumerGroupService service$2) {
        return ((SeqOps)((Option)service$2.collectGroupMembers($this.group(), false)._2()).get()).size() == 1;
    }

    public static final /* synthetic */ String $anonfun$testDeleteCmdNonEmptyGroup$2() {
        return "The group did not initialize as expected.";
    }

    public static final /* synthetic */ boolean $anonfun$testDeleteNonEmptyGroup$1(DeleteConsumerGroupsTest $this, ConsumerGroupCommand.ConsumerGroupService service$3) {
        return ((SeqOps)((Option)service$3.collectGroupMembers($this.group(), false)._2()).get()).size() == 1;
    }

    public static final /* synthetic */ String $anonfun$testDeleteNonEmptyGroup$2() {
        return "The group did not initialize as expected.";
    }

    public static final /* synthetic */ boolean $anonfun$testDeleteCmdEmptyGroup$1(DeleteConsumerGroupsTest $this, ConsumerGroupCommand.ConsumerGroupService service$4) {
        if (service$4.listConsumerGroups().contains((Object)$this.group())) {
            String string = service$4.collectGroupState($this.group()).state();
            String string2 = "Stable";
            if (string != null && string.equals(string2)) {
                return true;
            }
        }
        return false;
    }

    public static final /* synthetic */ String $anonfun$testDeleteCmdEmptyGroup$2() {
        return "The group did not initialize as expected.";
    }

    public static final /* synthetic */ boolean $anonfun$testDeleteCmdEmptyGroup$3(DeleteConsumerGroupsTest $this, ConsumerGroupCommand.ConsumerGroupService service$4) {
        String string = service$4.collectGroupState($this.group()).state();
        String string2 = "Empty";
        return string != null && string.equals(string2);
    }

    public static final /* synthetic */ String $anonfun$testDeleteCmdEmptyGroup$4() {
        return "The group did not become empty as expected.";
    }

    public static final /* synthetic */ Tuple2 $anonfun$testDeleteCmdAllGroups$1(DeleteConsumerGroupsTest $this, int i) {
        String group = new StringBuilder(0).append($this.group()).append(i).toString();
        String x$3 = $this.addConsumerGroupExecutor$default$2();
        String x$4 = $this.addConsumerGroupExecutor$default$4();
        Option<Properties> x$5 = $this.addConsumerGroupExecutor$default$5();
        boolean x$6 = $this.addConsumerGroupExecutor$default$6();
        ConsumerGroupCommandTest.ConsumerGroupExecutor executor = $this.addConsumerGroupExecutor(1, x$3, group, x$4, x$5, x$6);
        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)group), (Object)executor);
    }

    public static final /* synthetic */ boolean $anonfun$testDeleteCmdAllGroups$3(ConsumerGroupCommand.ConsumerGroupService service$5, String groupId) {
        String string = service$5.collectGroupState(groupId).state();
        String string2 = "Stable";
        return string != null && string.equals(string2);
    }

    public static final /* synthetic */ boolean $anonfun$testDeleteCmdAllGroups$2(ConsumerGroupCommand.ConsumerGroupService service$5, scala.collection.immutable.Map groups$1) {
        Set set = service$5.listConsumerGroups().toSet();
        Set set2 = groups$1.keySet();
        return !(set != null ? !set.equals(set2) : set2 != null) && groups$1.keySet().forall((Function1 & Serializable)groupId -> BoxesRunTime.boxToBoolean((boolean)DeleteConsumerGroupsTest.$anonfun$testDeleteCmdAllGroups$3(service$5, groupId)));
    }

    public static final /* synthetic */ String $anonfun$testDeleteCmdAllGroups$4() {
        return "The group did not initialize as expected.";
    }

    public static final /* synthetic */ boolean $anonfun$testDeleteCmdAllGroups$7(ConsumerGroupCommand.ConsumerGroupService service$5, String groupId) {
        String string = service$5.collectGroupState(groupId).state();
        String string2 = "Empty";
        return string != null && string.equals(string2);
    }

    public static final /* synthetic */ boolean $anonfun$testDeleteCmdAllGroups$6(scala.collection.immutable.Map groups$1, ConsumerGroupCommand.ConsumerGroupService service$5) {
        return groups$1.keySet().forall((Function1 & Serializable)groupId -> BoxesRunTime.boxToBoolean((boolean)DeleteConsumerGroupsTest.$anonfun$testDeleteCmdAllGroups$7(service$5, groupId)));
    }

    public static final /* synthetic */ String $anonfun$testDeleteCmdAllGroups$8() {
        return "The group did not become empty as expected.";
    }

    public static final /* synthetic */ void $anonfun$testDeleteCmdAllGroups$9(ConsumerGroupCommand.ConsumerGroupService service$5) {
        service$5.deleteGroups();
    }

    public static final /* synthetic */ String $anonfun$testDeleteCmdAllGroups$10(String x$1) {
        return x$1.replaceAll("'", "").trim();
    }

    public static final /* synthetic */ boolean $anonfun$testDeleteEmptyGroup$1(DeleteConsumerGroupsTest $this, ConsumerGroupCommand.ConsumerGroupService service$6) {
        if (service$6.listConsumerGroups().contains((Object)$this.group())) {
            String string = service$6.collectGroupState($this.group()).state();
            String string2 = "Stable";
            if (string != null && string.equals(string2)) {
                return true;
            }
        }
        return false;
    }

    public static final /* synthetic */ String $anonfun$testDeleteEmptyGroup$2() {
        return "The group did not initialize as expected.";
    }

    public static final /* synthetic */ boolean $anonfun$testDeleteEmptyGroup$3(DeleteConsumerGroupsTest $this, ConsumerGroupCommand.ConsumerGroupService service$6) {
        String string = service$6.collectGroupState($this.group()).state();
        String string2 = "Empty";
        return string != null && string.equals(string2);
    }

    public static final /* synthetic */ String $anonfun$testDeleteEmptyGroup$4() {
        return "The group did not become empty as expected.";
    }

    public static final /* synthetic */ boolean $anonfun$testDeleteCmdWithMixOfSuccessAndError$1(DeleteConsumerGroupsTest $this, ConsumerGroupCommand.ConsumerGroupService service$7) {
        if (service$7.listConsumerGroups().contains((Object)$this.group())) {
            String string = service$7.collectGroupState($this.group()).state();
            String string2 = "Stable";
            if (string != null && string.equals(string2)) {
                return true;
            }
        }
        return false;
    }

    public static final /* synthetic */ String $anonfun$testDeleteCmdWithMixOfSuccessAndError$2() {
        return "The group did not initialize as expected.";
    }

    public static final /* synthetic */ boolean $anonfun$testDeleteCmdWithMixOfSuccessAndError$3(DeleteConsumerGroupsTest $this, ConsumerGroupCommand.ConsumerGroupService service$7) {
        String string = service$7.collectGroupState($this.group()).state();
        String string2 = "Empty";
        return string != null && string.equals(string2);
    }

    public static final /* synthetic */ String $anonfun$testDeleteCmdWithMixOfSuccessAndError$4() {
        return "The group did not become empty as expected.";
    }

    public static final /* synthetic */ boolean $anonfun$testDeleteWithMixOfSuccessAndError$1(DeleteConsumerGroupsTest $this, ConsumerGroupCommand.ConsumerGroupService service$8) {
        if (service$8.listConsumerGroups().contains((Object)$this.group())) {
            String string = service$8.collectGroupState($this.group()).state();
            String string2 = "Stable";
            if (string != null && string.equals(string2)) {
                return true;
            }
        }
        return false;
    }

    public static final /* synthetic */ String $anonfun$testDeleteWithMixOfSuccessAndError$2() {
        return "The group did not initialize as expected.";
    }

    public static final /* synthetic */ boolean $anonfun$testDeleteWithMixOfSuccessAndError$3(DeleteConsumerGroupsTest $this, ConsumerGroupCommand.ConsumerGroupService service$8) {
        String string = service$8.collectGroupState($this.group()).state();
        String string2 = "Empty";
        return string != null && string.equals(string2);
    }

    public static final /* synthetic */ String $anonfun$testDeleteWithMixOfSuccessAndError$4() {
        return "The group did not become empty as expected.";
    }

    public static final /* synthetic */ Tuple2 $anonfun$testDeleteCmdAllGroups$1$adapted(DeleteConsumerGroupsTest $this, Object i) {
        return DeleteConsumerGroupsTest.$anonfun$testDeleteCmdAllGroups$1($this, BoxesRunTime.unboxToInt((Object)i));
    }

    public static final /* synthetic */ Object $anonfun$testDeleteCmdAllGroups$5$adapted(ConsumerGroupCommandTest.ConsumerGroupExecutor executor) {
        executor.shutdown();
        return BoxedUnit.UNIT;
    }
}

