/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.kstream.KeyValueMapper;
import org.apache.kafka.streams.processor.api.ContextualProcessor;
import org.apache.kafka.streams.processor.api.Processor;
import org.apache.kafka.streams.processor.api.ProcessorSupplier;
import org.apache.kafka.streams.processor.api.Record;

class KStreamMap<KIn, VIn, KOut, VOut>
implements ProcessorSupplier<KIn, VIn, KOut, VOut> {
    private final KeyValueMapper<? super KIn, ? super VIn, ? extends KeyValue<? extends KOut, ? extends VOut>> mapper;

    public KStreamMap(KeyValueMapper<? super KIn, ? super VIn, ? extends KeyValue<? extends KOut, ? extends VOut>> mapper) {
        this.mapper = mapper;
    }

    @Override
    public Processor<KIn, VIn, KOut, VOut> get() {
        return new KStreamMapProcessor();
    }

    private class KStreamMapProcessor
    extends ContextualProcessor<KIn, VIn, KOut, VOut> {
        private KStreamMapProcessor() {
        }

        @Override
        public void process(Record<KIn, VIn> record) {
            KeyValue newPair = (KeyValue)KStreamMap.this.mapper.apply(record.key(), record.value());
            this.context().forward(record.withKey(newPair.key).withValue(newPair.value));
        }
    }
}

