/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.common;

import java.util.Collections;
import java.util.HashMap;
import org.apache.kafka.server.common.FeatureVersion;
import org.apache.kafka.server.common.Features;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.server.common.TestFeatureVersion;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;

public class FeaturesTest {
    @ParameterizedTest
    @EnumSource(value=Features.class)
    public void testV0SupportedInEarliestMV(Features feature) {
        Assertions.assertTrue((feature.featureVersions().length >= 1 ? 1 : 0) != 0);
        Assertions.assertEquals((Object)MetadataVersion.MINIMUM_KRAFT_VERSION, (Object)feature.featureVersions()[0].bootstrapMetadataVersion());
    }

    @ParameterizedTest
    @EnumSource(value=Features.class)
    public void testFromFeatureLevelAllFeatures(Features feature) {
        FeatureVersion[] featureImplementations = feature.featureVersions();
        short numFeatures = featureImplementations.length;
        short latestProductionLevel = feature.latestProduction();
        for (short i = 0; i < numFeatures; i = (short)(i + 1)) {
            short level = i;
            if (latestProductionLevel < i) {
                Assertions.assertEquals((Object)featureImplementations[i], (Object)feature.fromFeatureLevel(level, true));
                Assertions.assertThrows(IllegalArgumentException.class, () -> feature.fromFeatureLevel(level, false));
                continue;
            }
            Assertions.assertEquals((Object)featureImplementations[i], (Object)feature.fromFeatureLevel(level, false));
        }
    }

    @ParameterizedTest
    @EnumSource(value=Features.class)
    public void testValidateVersionAllFeatures(Features feature) {
        for (FeatureVersion featureImpl : feature.featureVersions()) {
            HashMap<String, Short> deps = new HashMap<String, Short>();
            deps.putAll(featureImpl.dependencies());
            if (!deps.containsKey("metadata.version")) {
                deps.put("metadata.version", MetadataVersion.MINIMUM_BOOTSTRAP_VERSION.featureLevel());
            }
            Features.validateVersion((FeatureVersion)featureImpl, deps);
        }
    }

    @Test
    public void testInvalidValidateVersion() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> Features.validateVersion((FeatureVersion)TestFeatureVersion.TEST_1, Collections.emptyMap()));
        Assertions.assertThrows(IllegalArgumentException.class, () -> Features.validateVersion((FeatureVersion)TestFeatureVersion.TEST_1, Collections.singletonMap("metadata.version", MetadataVersion.IBP_2_8_IV0.featureLevel())));
        Assertions.assertThrows(IllegalArgumentException.class, () -> Features.validateVersion((FeatureVersion)TestFeatureVersion.TEST_2, Collections.singletonMap("metadata.version", MetadataVersion.IBP_3_7_IV0.featureLevel())));
    }

    @ParameterizedTest
    @EnumSource(value=Features.class)
    public void testDefaultValueAllFeatures(Features feature) {
        for (FeatureVersion featureImpl : feature.featureVersions()) {
            short defaultLevel = feature.defaultValue(featureImpl.bootstrapMetadataVersion());
            if (defaultLevel == featureImpl.featureLevel()) continue;
            FeatureVersion otherFeature = feature.fromFeatureLevel(defaultLevel, true);
            Assertions.assertEquals((Object)featureImpl.bootstrapMetadataVersion(), (Object)otherFeature.bootstrapMetadataVersion());
            Assertions.assertTrue((defaultLevel > featureImpl.featureLevel() ? 1 : 0) != 0);
        }
    }

    @ParameterizedTest
    @EnumSource(value=Features.class)
    public void testLatestProductionMapsToLatestMetadataVersion(Features features) {
        Assertions.assertEquals((short)features.latestProduction(), (short)features.defaultValue(MetadataVersion.LATEST_PRODUCTION));
    }

    @ParameterizedTest
    @EnumSource(value=MetadataVersion.class)
    public void testDefaultTestVersion(MetadataVersion metadataVersion) {
        short expectedVersion = !metadataVersion.isLessThan(MetadataVersion.IBP_4_0_IV0) ? (short)2 : (!metadataVersion.isLessThan(MetadataVersion.IBP_3_7_IV0) ? (short)1 : 0);
        Assertions.assertEquals((short)expectedVersion, (short)Features.TEST_VERSION.defaultValue(metadataVersion));
    }

    @Test
    public void testUnstableTestVersion() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> Features.TEST_VERSION.fromFeatureLevel(Features.TEST_VERSION.latestTesting(), false));
        Features.TEST_VERSION.fromFeatureLevel(Features.TEST_VERSION.latestTesting(), true);
    }
}

