/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.metadata;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.AssignReplicasToDirsRequestData;
import org.apache.kafka.metadata.AssignmentsHelper;
import org.apache.kafka.server.common.TopicIdPartition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class AssignmentsHelperTest {
    private static final Uuid TOPIC_1 = Uuid.fromString((String)"tJU174w8QiSXLimIdtUKKg");
    private static final Uuid TOPIC_2 = Uuid.fromString((String)"3vHa6oVIRKOmm0VYhGzTJQ");
    private static final Uuid DIR_1 = Uuid.fromString((String)"Nm6KAvyxQNS63HyB4yRsTQ");
    private static final Uuid DIR_2 = Uuid.fromString((String)"l3Rv0JxcRLCQ6rLoGbYUgQ");
    private static final Uuid DIR_3 = Uuid.fromString((String)"ILABYpv3SKOBjqws4SR8Ww");

    @Test
    public void testBuildRequestData() {
        HashMap<TopicIdPartition, Uuid> assignment = new HashMap<TopicIdPartition, Uuid>(){
            {
                this.put(new TopicIdPartition(TOPIC_1, 1), DIR_1);
                this.put(new TopicIdPartition(TOPIC_1, 2), DIR_2);
                this.put(new TopicIdPartition(TOPIC_1, 3), DIR_3);
                this.put(new TopicIdPartition(TOPIC_1, 4), DIR_1);
                this.put(new TopicIdPartition(TOPIC_2, 5), DIR_2);
            }
        };
        AssignReplicasToDirsRequestData built = AssignmentsHelper.buildRequestData((int)8, (long)100L, (Map)assignment);
        AssignReplicasToDirsRequestData expected = new AssignReplicasToDirsRequestData().setBrokerId(8).setBrokerEpoch(100L).setDirectories(Arrays.asList(new AssignReplicasToDirsRequestData.DirectoryData().setId(DIR_2).setTopics(Arrays.asList(new AssignReplicasToDirsRequestData.TopicData().setTopicId(TOPIC_1).setPartitions(Collections.singletonList(new AssignReplicasToDirsRequestData.PartitionData().setPartitionIndex(2))), new AssignReplicasToDirsRequestData.TopicData().setTopicId(TOPIC_2).setPartitions(Collections.singletonList(new AssignReplicasToDirsRequestData.PartitionData().setPartitionIndex(5))))), new AssignReplicasToDirsRequestData.DirectoryData().setId(DIR_3).setTopics(Collections.singletonList(new AssignReplicasToDirsRequestData.TopicData().setTopicId(TOPIC_1).setPartitions(Collections.singletonList(new AssignReplicasToDirsRequestData.PartitionData().setPartitionIndex(3))))), new AssignReplicasToDirsRequestData.DirectoryData().setId(DIR_1).setTopics(Collections.singletonList(new AssignReplicasToDirsRequestData.TopicData().setTopicId(TOPIC_1).setPartitions(Arrays.asList(new AssignReplicasToDirsRequestData.PartitionData().setPartitionIndex(4), new AssignReplicasToDirsRequestData.PartitionData().setPartitionIndex(1)))))));
        Assertions.assertEquals((Object)AssignmentsHelper.normalize((AssignReplicasToDirsRequestData)expected), (Object)AssignmentsHelper.normalize((AssignReplicasToDirsRequestData)built));
    }
}

