/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.ArrayOf;
import org.apache.kafka.common.protocol.types.CompactArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ByteUtils;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.common.utils.ImplicitLinkedHashMultiCollection;

public class DescribeLogDirsRequestData
implements ApiMessage {
    private DescribableLogDirTopicCollection topics;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0;
    public static final Schema SCHEMA_1;
    public static final Schema SCHEMA_2;
    public static final Schema[] SCHEMAS;

    public DescribeLogDirsRequestData(Readable _readable, short _version) {
        this.read(_readable, _version);
    }

    public DescribeLogDirsRequestData(Struct _struct, short _version) {
        this.fromStruct(_struct, _version);
    }

    public DescribeLogDirsRequestData() {
        this.topics = new DescribableLogDirTopicCollection(0);
    }

    public short apiKey() {
        return 35;
    }

    public short lowestSupportedVersion() {
        return 0;
    }

    public short highestSupportedVersion() {
        return 2;
    }

    public void read(Readable _readable, short _version) {
        int i;
        DescribableLogDirTopicCollection newCollection;
        int arrayLength;
        if (_version >= 2) {
            arrayLength = _readable.readUnsignedVarint() - 1;
            if (arrayLength < 0) {
                this.topics = null;
            } else {
                newCollection = new DescribableLogDirTopicCollection(arrayLength);
                for (i = 0; i < arrayLength; ++i) {
                    newCollection.add(new DescribableLogDirTopic(_readable, _version));
                }
                this.topics = newCollection;
            }
        } else {
            arrayLength = _readable.readInt();
            if (arrayLength < 0) {
                this.topics = null;
            } else {
                newCollection = new DescribableLogDirTopicCollection(arrayLength);
                for (i = 0; i < arrayLength; ++i) {
                    newCollection.add(new DescribableLogDirTopic(_readable, _version));
                }
                this.topics = newCollection;
            }
        }
        this._unknownTaggedFields = null;
        if (_version >= 2) {
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }
    }

    public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
        Iterator iterator;
        int _numTaggedFields = 0;
        if (_version >= 2) {
            if (this.topics == null) {
                _writable.writeUnsignedVarint(0);
            } else {
                _writable.writeUnsignedVarint(this.topics.size() + 1);
                iterator = this.topics.iterator();
                while (iterator.hasNext()) {
                    DescribableLogDirTopic topicsElement = (DescribableLogDirTopic)iterator.next();
                    topicsElement.write(_writable, _cache, _version);
                }
            }
        } else if (this.topics == null) {
            _writable.writeInt(-1);
        } else {
            _writable.writeInt(this.topics.size());
            iterator = this.topics.iterator();
            while (iterator.hasNext()) {
                DescribableLogDirTopic topicsElement = (DescribableLogDirTopic)iterator.next();
                topicsElement.write(_writable, _cache, _version);
            }
        }
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        _numTaggedFields += _rawWriter.numFields();
        if (_version >= 2) {
            _writable.writeUnsignedVarint(_numTaggedFields);
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        } else if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
    }

    public void fromStruct(Struct struct, short _version) {
        Object[] _nestedObjects;
        NavigableMap _taggedFields = null;
        this._unknownTaggedFields = null;
        if (_version >= 2) {
            _taggedFields = (NavigableMap)struct.get("_tagged_fields");
        }
        if ((_nestedObjects = struct.getArray("topics")) == null) {
            this.topics = null;
        } else {
            this.topics = new DescribableLogDirTopicCollection(_nestedObjects.length);
            for (Object nestedObject : _nestedObjects) {
                this.topics.add(new DescribableLogDirTopic((Struct)nestedObject, _version));
            }
        }
        if (_version >= 2 && !_taggedFields.isEmpty()) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(_taggedFields.size());
            for (Map.Entry entry : _taggedFields.entrySet()) {
                this._unknownTaggedFields.add((RawTaggedField)entry.getValue());
            }
        }
    }

    public Struct toStruct(short _version) {
        TreeMap _taggedFields = null;
        if (_version >= 2) {
            _taggedFields = new TreeMap();
        }
        Struct struct = new Struct(SCHEMAS[_version]);
        if (this.topics == null) {
            struct.set("topics", null);
        } else {
            Struct[] _nestedObjects = new Struct[this.topics.size()];
            int i = 0;
            Iterator iterator = this.topics.iterator();
            while (iterator.hasNext()) {
                DescribableLogDirTopic element = (DescribableLogDirTopic)iterator.next();
                _nestedObjects[i++] = element.toStruct(_version);
            }
            struct.set("topics", (Object)_nestedObjects);
        }
        if (_version >= 2) {
            struct.set("_tagged_fields", _taggedFields);
        }
        return struct;
    }

    public int size(ObjectSerializationCache _cache, short _version) {
        int _size = 0;
        int _numTaggedFields = 0;
        if (this.topics == null) {
            _size = _version >= 2 ? ++_size : (_size += 4);
        } else {
            int _arraySize = 0;
            _arraySize = _version >= 2 ? (_arraySize += ByteUtils.sizeOfUnsignedVarint((int)(this.topics.size() + 1))) : (_arraySize += 4);
            Iterator iterator = this.topics.iterator();
            while (iterator.hasNext()) {
                DescribableLogDirTopic topicsElement = (DescribableLogDirTopic)iterator.next();
                _arraySize += topicsElement.size(_cache, _version);
            }
            _size += _arraySize;
        }
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size += ByteUtils.sizeOfUnsignedVarint((int)_field.tag());
                _size += ByteUtils.sizeOfUnsignedVarint((int)_field.size());
                _size += _field.size();
            }
        }
        if (_version >= 2) {
            _size += ByteUtils.sizeOfUnsignedVarint((int)_numTaggedFields);
        } else if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
        return _size;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DescribeLogDirsRequestData)) {
            return false;
        }
        DescribeLogDirsRequestData other = (DescribeLogDirsRequestData)obj;
        return !(this.topics == null ? other.topics != null : !this.topics.equals((Object)other.topics));
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + (this.topics == null ? 0 : this.topics.hashCode());
        return hashCode;
    }

    public DescribeLogDirsRequestData duplicate() {
        DescribeLogDirsRequestData _duplicate = new DescribeLogDirsRequestData();
        if (this.topics == null) {
            _duplicate.topics = null;
        } else {
            DescribableLogDirTopicCollection newTopics = new DescribableLogDirTopicCollection(this.topics.size());
            Iterator iterator = this.topics.iterator();
            while (iterator.hasNext()) {
                DescribableLogDirTopic _element = (DescribableLogDirTopic)iterator.next();
                newTopics.add(_element.duplicate());
            }
            _duplicate.topics = newTopics;
        }
        return _duplicate;
    }

    public String toString() {
        return "DescribeLogDirsRequestData(topics=" + (this.topics == null ? "null" : MessageUtil.deepToString((Iterator)this.topics.iterator())) + ")";
    }

    public DescribableLogDirTopicCollection topics() {
        return this.topics;
    }

    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public DescribeLogDirsRequestData setTopics(DescribableLogDirTopicCollection v) {
        this.topics = v;
        return this;
    }

    static {
        SCHEMA_1 = SCHEMA_0 = new Schema(new Field[]{new Field("topics", (Type)ArrayOf.nullable((Type)DescribableLogDirTopic.SCHEMA_0), "Each topic that we want to describe log directories for, or null for all topics.")});
        SCHEMA_2 = new Schema(new Field[]{new Field("topics", (Type)CompactArrayOf.nullable((Type)DescribableLogDirTopic.SCHEMA_2), "Each topic that we want to describe log directories for, or null for all topics."), Field.TaggedFieldsSection.of((Object[])new Object[0])});
        SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2};
    }

    public static class DescribableLogDirTopicCollection
    extends ImplicitLinkedHashMultiCollection<DescribableLogDirTopic> {
        public DescribableLogDirTopicCollection() {
        }

        public DescribableLogDirTopicCollection(int expectedNumElements) {
            super(expectedNumElements);
        }

        public DescribableLogDirTopicCollection(Iterator<DescribableLogDirTopic> iterator) {
            super(iterator);
        }

        public DescribableLogDirTopic find(String topic) {
            DescribableLogDirTopic _key = new DescribableLogDirTopic();
            _key.setTopic(topic);
            return (DescribableLogDirTopic)this.find(_key);
        }

        public List<DescribableLogDirTopic> findAll(String topic) {
            DescribableLogDirTopic _key = new DescribableLogDirTopic();
            _key.setTopic(topic);
            return this.findAll(_key);
        }

        public DescribableLogDirTopicCollection duplicate() {
            DescribableLogDirTopicCollection _duplicate = new DescribableLogDirTopicCollection(this.size());
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                DescribableLogDirTopic _element = (DescribableLogDirTopic)iterator.next();
                _duplicate.add(_element.duplicate());
            }
            return _duplicate;
        }
    }

    public static class DescribableLogDirTopic
    implements Message,
    ImplicitLinkedHashCollection.Element {
        private String topic;
        private List<Integer> partitionIndex;
        private List<RawTaggedField> _unknownTaggedFields;
        private int next;
        private int prev;
        public static final Schema SCHEMA_0;
        public static final Schema SCHEMA_1;
        public static final Schema SCHEMA_2;
        public static final Schema[] SCHEMAS;

        public DescribableLogDirTopic(Readable _readable, short _version) {
            this.read(_readable, _version);
            this.prev = -2;
            this.next = -2;
        }

        public DescribableLogDirTopic(Struct _struct, short _version) {
            this.fromStruct(_struct, _version);
            this.prev = -2;
            this.next = -2;
        }

        public DescribableLogDirTopic() {
            this.topic = "";
            this.partitionIndex = new ArrayList<Integer>(0);
            this.prev = -2;
            this.next = -2;
        }

        public short lowestSupportedVersion() {
            return 0;
        }

        public short highestSupportedVersion() {
            return 2;
        }

        public void read(Readable _readable, short _version) {
            if (_version > 2) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of DescribableLogDirTopic");
            }
            int length = _version >= 2 ? _readable.readUnsignedVarint() - 1 : _readable.readShort();
            if (length < 0) {
                throw new RuntimeException("non-nullable field topic was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field topic had invalid length " + length);
            }
            this.topic = _readable.readString(length);
            int arrayLength = _version >= 2 ? _readable.readUnsignedVarint() - 1 : _readable.readInt();
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field partitionIndex was serialized as null");
            }
            ArrayList<Integer> newCollection = new ArrayList<Integer>(arrayLength);
            for (int i = 0; i < arrayLength; ++i) {
                newCollection.add(_readable.readInt());
            }
            this.partitionIndex = newCollection;
            this._unknownTaggedFields = null;
            if (_version >= 2) {
                int _numTaggedFields = _readable.readUnsignedVarint();
                for (int _i = 0; _i < _numTaggedFields; ++_i) {
                    int _tag = _readable.readUnsignedVarint();
                    int _size = _readable.readUnsignedVarint();
                    switch (_tag) {
                        default: 
                    }
                    this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
                }
            }
        }

        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            Object _stringBytes = _cache.getSerializedValue((Object)this.topic);
            if (_version >= 2) {
                _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
            } else {
                _writable.writeShort((short)((byte[])_stringBytes).length);
            }
            _writable.writeByteArray((byte[])_stringBytes);
            if (_version >= 2) {
                _writable.writeUnsignedVarint(this.partitionIndex.size() + 1);
            } else {
                _writable.writeInt(this.partitionIndex.size());
            }
            _stringBytes = this.partitionIndex.iterator();
            while (_stringBytes.hasNext()) {
                Integer partitionIndexElement = (Integer)_stringBytes.next();
                _writable.writeInt(partitionIndexElement.intValue());
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _numTaggedFields += _rawWriter.numFields();
            if (_version >= 2) {
                _writable.writeUnsignedVarint(_numTaggedFields);
                _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        public void fromStruct(Struct struct, short _version) {
            if (_version > 2) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of DescribableLogDirTopic");
            }
            NavigableMap _taggedFields = null;
            this._unknownTaggedFields = null;
            if (_version >= 2) {
                _taggedFields = (NavigableMap)struct.get("_tagged_fields");
            }
            this.topic = struct.getString("topic");
            Object[] _nestedObjects = struct.getArray("partition_index");
            this.partitionIndex = new ArrayList<Integer>(_nestedObjects.length);
            for (Object nestedObject : _nestedObjects) {
                this.partitionIndex.add((Integer)nestedObject);
            }
            if (_version >= 2 && !_taggedFields.isEmpty()) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(_taggedFields.size());
                for (Map.Entry entry : _taggedFields.entrySet()) {
                    this._unknownTaggedFields.add((RawTaggedField)entry.getValue());
                }
            }
        }

        public Struct toStruct(short _version) {
            if (_version > 2) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of DescribableLogDirTopic");
            }
            TreeMap _taggedFields = null;
            if (_version >= 2) {
                _taggedFields = new TreeMap();
            }
            Struct struct = new Struct(SCHEMAS[_version]);
            struct.set("topic", (Object)this.topic);
            Integer[] _nestedObjects = new Integer[this.partitionIndex.size()];
            int i = 0;
            for (Integer element : this.partitionIndex) {
                _nestedObjects[i++] = element;
            }
            struct.set("partition_index", (Object)_nestedObjects);
            if (_version >= 2) {
                struct.set("_tagged_fields", _taggedFields);
            }
            return struct;
        }

        public int size(ObjectSerializationCache _cache, short _version) {
            int _size = 0;
            int _numTaggedFields = 0;
            if (_version > 2) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of DescribableLogDirTopic");
            }
            byte[] _stringBytes = this.topic.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'topic' field is too long to be serialized");
            }
            _cache.cacheSerializedValue((Object)this.topic, _stringBytes);
            _size = _version >= 2 ? (_size += _stringBytes.length + ByteUtils.sizeOfUnsignedVarint((int)(_stringBytes.length + 1))) : (_size += _stringBytes.length + 2);
            int _arraySize = 0;
            _arraySize = _version >= 2 ? (_arraySize += ByteUtils.sizeOfUnsignedVarint((int)(this.partitionIndex.size() + 1))) : (_arraySize += 4);
            _size += (_arraySize += this.partitionIndex.size() * 4);
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size += ByteUtils.sizeOfUnsignedVarint((int)_field.tag());
                    _size += ByteUtils.sizeOfUnsignedVarint((int)_field.size());
                    _size += _field.size();
                }
            }
            if (_version >= 2) {
                _size += ByteUtils.sizeOfUnsignedVarint((int)_numTaggedFields);
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
            return _size;
        }

        public boolean elementKeysAreEqual(Object obj) {
            if (!(obj instanceof DescribableLogDirTopic)) {
                return false;
            }
            DescribableLogDirTopic other = (DescribableLogDirTopic)obj;
            return !(this.topic == null ? other.topic != null : !this.topic.equals(other.topic));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof DescribableLogDirTopic)) {
                return false;
            }
            DescribableLogDirTopic other = (DescribableLogDirTopic)obj;
            if (this.topic == null ? other.topic != null : !this.topic.equals(other.topic)) {
                return false;
            }
            return !(this.partitionIndex == null ? other.partitionIndex != null : !this.partitionIndex.equals(other.partitionIndex));
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.topic == null ? 0 : this.topic.hashCode());
            return hashCode;
        }

        public DescribableLogDirTopic duplicate() {
            DescribableLogDirTopic _duplicate = new DescribableLogDirTopic();
            _duplicate.topic = this.topic;
            ArrayList<Integer> newPartitionIndex = new ArrayList<Integer>(this.partitionIndex.size());
            for (Integer _element : this.partitionIndex) {
                newPartitionIndex.add(_element);
            }
            _duplicate.partitionIndex = newPartitionIndex;
            return _duplicate;
        }

        public String toString() {
            return "DescribableLogDirTopic(topic=" + (this.topic == null ? "null" : "'" + this.topic.toString() + "'") + ", partitionIndex=" + MessageUtil.deepToString(this.partitionIndex.iterator()) + ")";
        }

        public String topic() {
            return this.topic;
        }

        public List<Integer> partitionIndex() {
            return this.partitionIndex;
        }

        public int next() {
            return this.next;
        }

        public int prev() {
            return this.prev;
        }

        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public DescribableLogDirTopic setTopic(String v) {
            this.topic = v;
            return this;
        }

        public DescribableLogDirTopic setPartitionIndex(List<Integer> v) {
            this.partitionIndex = v;
            return this;
        }

        public void setNext(int v) {
            this.next = v;
        }

        public void setPrev(int v) {
            this.prev = v;
        }

        static {
            SCHEMA_1 = SCHEMA_0 = new Schema(new Field[]{new Field("topic", (Type)Type.STRING, "The topic name"), new Field("partition_index", (Type)new ArrayOf((Type)Type.INT32), "The partition indxes.")});
            SCHEMA_2 = new Schema(new Field[]{new Field("topic", (Type)Type.COMPACT_STRING, "The topic name"), new Field("partition_index", (Type)new CompactArrayOf((Type)Type.INT32), "The partition indxes."), Field.TaggedFieldsSection.of((Object[])new Object[0])});
            SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2};
        }
    }
}

