/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.ldap.config.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.apache.jmeter.config.gui.AbstractConfigGui;
import org.apache.jmeter.gui.TestElementMetadata;
import org.apache.jmeter.gui.util.HeaderAsPropertyRenderer;
import org.apache.jmeter.protocol.ldap.config.gui.LDAPArgument;
import org.apache.jmeter.protocol.ldap.config.gui.LDAPArguments;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.property.PropertyIterator;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.gui.GuiUtils;
import org.apache.jorphan.gui.ObjectTableModel;
import org.apache.jorphan.reflect.Functor;

@TestElementMetadata(labelResource="ldapext_sample_title", actionGroups={""})
public class LDAPArgumentsPanel
extends AbstractConfigGui
implements ActionListener {
    private static final long serialVersionUID = 240L;
    private JLabel tableLabel;
    private transient JTable table;
    transient ObjectTableModel tableModel;
    private JButton delete;
    private static final String ADD = "add";
    private static final String DELETE = "delete";
    private static final String[] COLUMN_NAMES = new String[]{"attribute", "value", "opcode", "metadata"};

    public LDAPArgumentsPanel() {
        this(JMeterUtils.getResString((String)"paramtable"));
    }

    public LDAPArgumentsPanel(String label) {
        this.tableLabel = new JLabel(label);
        this.init();
    }

    public Collection<String> getMenuCategories() {
        return null;
    }

    public String getLabelResource() {
        return "ldapext_sample_title";
    }

    public TestElement createTestElement() {
        LDAPArguments args = new LDAPArguments();
        this.modifyTestElement((TestElement)args);
        return (TestElement)args.clone();
    }

    public void modifyTestElement(TestElement args) {
        GuiUtils.stopTableEditing((JTable)this.table);
        if (args instanceof LDAPArguments) {
            LDAPArguments arguments = (LDAPArguments)args;
            arguments.clear();
            for (LDAPArgument arg : this.tableModel) {
                arg.setMetaData("=");
                arguments.addArgument(arg);
            }
        }
        super.configureTestElement(args);
    }

    public void configure(TestElement el) {
        super.configure(el);
        if (el instanceof LDAPArguments) {
            this.tableModel.clearData();
            PropertyIterator iter = ((LDAPArguments)el).iterator();
            while (iter.hasNext()) {
                LDAPArgument arg = (LDAPArgument)iter.next().getObjectValue();
                this.tableModel.addRow((Object)arg);
            }
        }
        this.checkDeleteStatus();
    }

    private void checkDeleteStatus() {
        if (this.tableModel.getRowCount() == 0) {
            this.delete.setEnabled(false);
        } else {
            this.delete.setEnabled(true);
        }
    }

    public void clear() {
        this.tableModel.clearData();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String action = e.getActionCommand();
        if (action.equals(DELETE)) {
            this.deleteArgument();
        } else if (action.equals(ADD)) {
            this.addArgument();
        }
    }

    private void deleteArgument() {
        GuiUtils.cancelEditing((JTable)this.table);
        int rowSelected = this.table.getSelectedRow();
        if (rowSelected >= 0) {
            this.tableModel.removeRow(rowSelected);
            this.tableModel.fireTableDataChanged();
            if (this.tableModel.getRowCount() == 0) {
                this.delete.setEnabled(false);
            } else {
                int rowToSelect = rowSelected;
                if (rowSelected >= this.tableModel.getRowCount()) {
                    rowToSelect = rowSelected - 1;
                }
                this.table.setRowSelectionInterval(rowToSelect, rowToSelect);
            }
        }
    }

    private void addArgument() {
        GuiUtils.stopTableEditing((JTable)this.table);
        this.tableModel.addRow((Object)this.makeNewLDAPArgument());
        this.delete.setEnabled(true);
        int rowToSelect = this.tableModel.getRowCount() - 1;
        this.table.setRowSelectionInterval(rowToSelect, rowToSelect);
    }

    private LDAPArgument makeNewLDAPArgument() {
        return new LDAPArgument("", "", "");
    }

    private void initializeTableModel() {
        this.tableModel = new ObjectTableModel(new String[]{COLUMN_NAMES[0], COLUMN_NAMES[1], COLUMN_NAMES[2]}, LDAPArgument.class, new Functor[]{new Functor("getName"), new Functor("getValue"), new Functor("getOpcode")}, new Functor[]{new Functor("setName"), new Functor("setValue"), new Functor("setOpcode")}, new Class[]{String.class, String.class, String.class});
    }

    public static boolean testFunctors() {
        LDAPArgumentsPanel instance = new LDAPArgumentsPanel();
        instance.initializeTableModel();
        return instance.tableModel.checkFunctors(null, instance.getClass());
    }

    private Component makeMainPanel() {
        this.initializeTableModel();
        this.table = new JTable((TableModel)this.tableModel);
        JMeterUtils.applyHiDPI((JTable)this.table);
        this.table.getTableHeader().setDefaultRenderer((TableCellRenderer)new HeaderAsPropertyRenderer());
        this.table.setSelectionMode(0);
        return this.makeScrollPane(this.table);
    }

    private Component makeLabelPanel() {
        JPanel labelPanel = new JPanel(new FlowLayout(1));
        labelPanel.add(this.tableLabel);
        return labelPanel;
    }

    private JPanel makeButtonPanel() {
        JButton add = new JButton(JMeterUtils.getResString((String)ADD));
        add.setActionCommand(ADD);
        add.setEnabled(true);
        this.delete = new JButton(JMeterUtils.getResString((String)DELETE));
        this.delete.setActionCommand(DELETE);
        this.checkDeleteStatus();
        JPanel buttonPanel = new JPanel();
        buttonPanel.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 10));
        add.addActionListener(this);
        this.delete.addActionListener(this);
        buttonPanel.add(add);
        buttonPanel.add(this.delete);
        return buttonPanel;
    }

    private void init() {
        this.setLayout(new BorderLayout());
        this.add(this.makeLabelPanel(), "North");
        this.add(this.makeMainPanel(), "Center");
        this.add(Box.createVerticalStrut(70), "West");
        this.add(this.makeButtonPanel(), "South");
        this.table.revalidate();
    }
}

