/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.read.controller;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.iotdb.tsfile.common.cache.LRUCache;
import org.apache.iotdb.tsfile.file.metadata.AlignedTimeSeriesMetadata;
import org.apache.iotdb.tsfile.file.metadata.ChunkMetadata;
import org.apache.iotdb.tsfile.file.metadata.IChunkMetadata;
import org.apache.iotdb.tsfile.file.metadata.ITimeSeriesMetadata;
import org.apache.iotdb.tsfile.file.metadata.TimeseriesMetadata;
import org.apache.iotdb.tsfile.file.metadata.TsFileMetadata;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.TsFileSequenceReader;
import org.apache.iotdb.tsfile.read.common.Path;
import org.apache.iotdb.tsfile.read.common.TimeRange;
import org.apache.iotdb.tsfile.read.controller.IMetadataQuerier;

public class MetadataQuerierByFileImpl
implements IMetadataQuerier {
    private static final int CACHED_ENTRY_NUMBER = 1000;
    private TsFileMetadata fileMetaData;
    private LRUCache<Path, List<IChunkMetadata>> chunkMetaDataCache;
    private TsFileSequenceReader tsFileReader;

    public MetadataQuerierByFileImpl(TsFileSequenceReader tsFileReader) throws IOException {
        this.tsFileReader = tsFileReader;
        this.fileMetaData = tsFileReader.readFileMetadata();
        this.chunkMetaDataCache = new LRUCache<Path, List<IChunkMetadata>>(1000){

            @Override
            public List<IChunkMetadata> loadObjectByKey(Path key) throws IOException {
                return MetadataQuerierByFileImpl.this.loadChunkMetadata(key);
            }
        };
    }

    @Override
    public List<IChunkMetadata> getChunkMetaDataList(Path timeseriesPath) throws IOException {
        return new ArrayList<IChunkMetadata>((Collection)this.chunkMetaDataCache.get(timeseriesPath));
    }

    @Override
    public Map<Path, List<IChunkMetadata>> getChunkMetaDataMap(List<Path> paths) throws IOException {
        HashMap<Path, List<IChunkMetadata>> chunkMetaDatas = new HashMap<Path, List<IChunkMetadata>>();
        for (Path path : paths) {
            if (!chunkMetaDatas.containsKey(path)) {
                chunkMetaDatas.put(path, new ArrayList());
            }
            ((List)chunkMetaDatas.get(path)).addAll(this.getChunkMetaDataList(path));
        }
        return chunkMetaDatas;
    }

    @Override
    public TsFileMetadata getWholeFileMetadata() {
        return this.fileMetaData;
    }

    @Override
    public void loadChunkMetaDatas(List<Path> paths) throws IOException {
        TreeMap deviceMeasurementsMap = new TreeMap();
        for (Path path : paths) {
            if (!deviceMeasurementsMap.containsKey(path.getDevice())) {
                deviceMeasurementsMap.put(path.getDevice(), new HashSet());
            }
            ((Set)deviceMeasurementsMap.get(path.getDevice())).add(path.getMeasurement());
        }
        int count = 0;
        boolean enough = false;
        block1: for (Map.Entry deviceMeasurements : deviceMeasurementsMap.entrySet()) {
            if (enough) break;
            String selectedDevice = (String)deviceMeasurements.getKey();
            Set selectedMeasurements = (Set)deviceMeasurements.getValue();
            List<String> devices = this.tsFileReader.getAllDevices();
            Object[] deviceNames = devices.toArray(new String[0]);
            if (Arrays.binarySearch(deviceNames, selectedDevice) < 0) continue;
            List<ITimeSeriesMetadata> timeseriesMetaDataList = this.tsFileReader.readITimeseriesMetadata(selectedDevice, selectedMeasurements);
            for (ITimeSeriesMetadata timeseriesMetadata : timeseriesMetaDataList) {
                List<IChunkMetadata> chunkMetadataList = this.tsFileReader.readIChunkMetaDataList(timeseriesMetadata);
                String measurementId = timeseriesMetadata instanceof AlignedTimeSeriesMetadata ? ((AlignedTimeSeriesMetadata)timeseriesMetadata).getValueTimeseriesMetadataList().get(0).getMeasurementId() : ((TimeseriesMetadata)timeseriesMetadata).getMeasurementId();
                this.chunkMetaDataCache.put(new Path(selectedDevice, measurementId, true), chunkMetadataList);
                if ((count += chunkMetadataList.size()) != 1000) continue;
                enough = true;
                continue block1;
            }
        }
    }

    @Override
    public TSDataType getDataType(Path path) throws IOException {
        if (this.tsFileReader.getChunkMetadataList(path) == null || this.tsFileReader.getChunkMetadataList(path).isEmpty()) {
            return null;
        }
        return this.tsFileReader.getChunkMetadataList(path).get(0).getDataType();
    }

    private List<IChunkMetadata> loadChunkMetadata(Path path) throws IOException {
        return this.tsFileReader.getIChunkMetadataList(path);
    }

    @Override
    public List<TimeRange> convertSpace2TimePartition(List<Path> paths, long spacePartitionStartPos, long spacePartitionEndPos) throws IOException {
        if (spacePartitionStartPos > spacePartitionEndPos) {
            throw new IllegalArgumentException("'spacePartitionStartPos' should not be larger than 'spacePartitionEndPos'.");
        }
        ArrayList<TimeRange> timeRangesInCandidates = new ArrayList<TimeRange>();
        ArrayList<TimeRange> timeRangesBeforeCandidates = new ArrayList<TimeRange>();
        TreeMap<String, Set> deviceMeasurementsMap = new TreeMap<String, Set>();
        for (Path path : paths) {
            deviceMeasurementsMap.computeIfAbsent(path.getDevice(), key -> new HashSet()).add(path.getMeasurement());
        }
        for (Map.Entry entry : deviceMeasurementsMap.entrySet()) {
            String selectedDevice = (String)entry.getKey();
            Set selectedMeasurements = (Set)entry.getValue();
            Map<String, List<ChunkMetadata>> seriesMetadatas = this.tsFileReader.readChunkMetadataInDevice(selectedDevice);
            for (Map.Entry<String, List<ChunkMetadata>> seriesMetadata : seriesMetadatas.entrySet()) {
                IChunkMetadata chunkMetadata;
                TsFileSequenceReader.LocateStatus location;
                if (!selectedMeasurements.contains(seriesMetadata.getKey())) continue;
                Iterator<ChunkMetadata> iterator = seriesMetadata.getValue().iterator();
                while (iterator.hasNext() && (location = MetadataQuerierByFileImpl.checkLocateStatus(chunkMetadata = (IChunkMetadata)iterator.next(), spacePartitionStartPos, spacePartitionEndPos)) != TsFileSequenceReader.LocateStatus.after) {
                    if (location == TsFileSequenceReader.LocateStatus.in) {
                        timeRangesInCandidates.add(new TimeRange(chunkMetadata.getStartTime(), chunkMetadata.getEndTime()));
                        continue;
                    }
                    timeRangesBeforeCandidates.add(new TimeRange(chunkMetadata.getStartTime(), chunkMetadata.getEndTime()));
                }
            }
        }
        ArrayList<TimeRange> timeRangesIn = new ArrayList<TimeRange>(TimeRange.sortAndMerge(timeRangesInCandidates));
        if (timeRangesIn.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<TimeRange> arrayList = new ArrayList<TimeRange>(TimeRange.sortAndMerge(timeRangesBeforeCandidates));
        ArrayList<TimeRange> resTimeRanges = new ArrayList<TimeRange>();
        for (TimeRange in : timeRangesIn) {
            ArrayList<TimeRange> remains = new ArrayList<TimeRange>(in.getRemains(arrayList));
            resTimeRanges.addAll(remains);
        }
        return resTimeRanges;
    }

    public static TsFileSequenceReader.LocateStatus checkLocateStatus(IChunkMetadata chunkMetaData, long spacePartitionStartPos, long spacePartitionEndPos) {
        long startOffsetOfChunk = chunkMetaData.getOffsetOfChunkHeader();
        if (spacePartitionStartPos <= startOffsetOfChunk && startOffsetOfChunk < spacePartitionEndPos) {
            return TsFileSequenceReader.LocateStatus.in;
        }
        if (startOffsetOfChunk < spacePartitionStartPos) {
            return TsFileSequenceReader.LocateStatus.before;
        }
        return TsFileSequenceReader.LocateStatus.after;
    }

    @Override
    public void clear() {
        this.chunkMetaDataCache.clear();
    }
}

