/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.read.common.block.column;

import io.airlift.slice.SizeOf;
import java.util.Arrays;
import org.apache.iotdb.tsfile.exception.write.UnSupportedDataTypeException;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.block.column.Column;
import org.apache.iotdb.tsfile.read.common.block.column.ColumnBuilder;
import org.apache.iotdb.tsfile.read.common.block.column.ColumnBuilderStatus;
import org.apache.iotdb.tsfile.read.common.block.column.ColumnUtil;
import org.apache.iotdb.tsfile.read.common.block.column.IntColumn;
import org.apache.iotdb.tsfile.read.common.block.column.RunLengthEncodedColumn;
import org.apache.iotdb.tsfile.utils.TsPrimitiveType;
import org.openjdk.jol.info.ClassLayout;

public class IntColumnBuilder
implements ColumnBuilder {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(IntColumnBuilder.class).instanceSize();
    public static final IntColumn NULL_VALUE_BLOCK = new IntColumn(0, 1, new boolean[]{true}, new int[1]);
    private final ColumnBuilderStatus columnBuilderStatus;
    private boolean initialized;
    private final int initialEntryCount;
    private int positionCount;
    private boolean hasNullValue;
    private boolean hasNonNullValue;
    private boolean[] valueIsNull = new boolean[0];
    private int[] values = new int[0];
    private long retainedSizeInBytes;

    public IntColumnBuilder(ColumnBuilderStatus columnBuilderStatus, int expectedEntries) {
        this.columnBuilderStatus = columnBuilderStatus;
        this.initialEntryCount = Math.max(expectedEntries, 1);
        this.updateDataSize();
    }

    @Override
    public ColumnBuilder writeInt(int value) {
        if (this.values.length <= this.positionCount) {
            this.growCapacity();
        }
        this.values[this.positionCount] = value;
        this.hasNonNullValue = true;
        ++this.positionCount;
        if (this.columnBuilderStatus != null) {
            this.columnBuilderStatus.addBytes(5);
        }
        return this;
    }

    @Override
    public ColumnBuilder writeObject(Object value) {
        if (value instanceof Integer) {
            this.writeInt((Integer)value);
            return this;
        }
        throw new UnSupportedDataTypeException("IntegerColumn only support Integer data type");
    }

    @Override
    public ColumnBuilder write(Column column, int index) {
        return this.writeInt(column.getInt(index));
    }

    @Override
    public ColumnBuilder writeTsPrimitiveType(TsPrimitiveType value) {
        return this.writeInt(value.getInt());
    }

    @Override
    public ColumnBuilder appendNull() {
        if (this.values.length <= this.positionCount) {
            this.growCapacity();
        }
        this.valueIsNull[this.positionCount] = true;
        this.hasNullValue = true;
        ++this.positionCount;
        if (this.columnBuilderStatus != null) {
            this.columnBuilderStatus.addBytes(5);
        }
        return this;
    }

    @Override
    public Column build() {
        if (!this.hasNonNullValue) {
            return new RunLengthEncodedColumn(NULL_VALUE_BLOCK, this.positionCount);
        }
        return new IntColumn(0, this.positionCount, this.hasNullValue ? this.valueIsNull : null, this.values);
    }

    @Override
    public TSDataType getDataType() {
        return TSDataType.INT32;
    }

    @Override
    public long getRetainedSizeInBytes() {
        return this.retainedSizeInBytes;
    }

    @Override
    public ColumnBuilder newColumnBuilderLike(ColumnBuilderStatus columnBuilderStatus) {
        return new IntColumnBuilder(columnBuilderStatus, ColumnUtil.calculateBlockResetSize(this.positionCount));
    }

    private void growCapacity() {
        int newSize;
        if (this.initialized) {
            newSize = ColumnUtil.calculateNewArraySize(this.values.length);
        } else {
            newSize = this.initialEntryCount;
            this.initialized = true;
        }
        this.valueIsNull = Arrays.copyOf(this.valueIsNull, newSize);
        this.values = Arrays.copyOf(this.values, newSize);
        this.updateDataSize();
    }

    private void updateDataSize() {
        this.retainedSizeInBytes = (long)INSTANCE_SIZE + SizeOf.sizeOf((boolean[])this.valueIsNull) + SizeOf.sizeOf((int[])this.values);
        if (this.columnBuilderStatus != null) {
            this.retainedSizeInBytes += (long)ColumnBuilderStatus.INSTANCE_SIZE;
        }
    }
}

