/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.file.metadata;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.iotdb.tsfile.common.conf.TSFileConfig;
import org.apache.iotdb.tsfile.common.conf.TSFileDescriptor;
import org.apache.iotdb.tsfile.file.metadata.MetadataIndexEntry;
import org.apache.iotdb.tsfile.file.metadata.enums.MetadataIndexNodeType;
import org.apache.iotdb.tsfile.utils.Pair;
import org.apache.iotdb.tsfile.utils.ReadWriteForEncodingUtils;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class MetadataIndexNode {
    private static final TSFileConfig config = TSFileDescriptor.getInstance().getConfig();
    private final List<MetadataIndexEntry> children;
    private long endOffset;
    private final MetadataIndexNodeType nodeType;

    public MetadataIndexNode(MetadataIndexNodeType nodeType) {
        this.children = new ArrayList<MetadataIndexEntry>();
        this.endOffset = -1L;
        this.nodeType = nodeType;
    }

    public MetadataIndexNode(List<MetadataIndexEntry> children, long endOffset, MetadataIndexNodeType nodeType) {
        this.children = children;
        this.endOffset = endOffset;
        this.nodeType = nodeType;
    }

    public List<MetadataIndexEntry> getChildren() {
        return this.children;
    }

    public long getEndOffset() {
        return this.endOffset;
    }

    public void setEndOffset(long endOffset) {
        this.endOffset = endOffset;
    }

    public MetadataIndexNodeType getNodeType() {
        return this.nodeType;
    }

    public void addEntry(MetadataIndexEntry metadataIndexEntry) {
        this.children.add(metadataIndexEntry);
    }

    public boolean isFull() {
        return this.children.size() >= config.getMaxDegreeOfIndexNode();
    }

    MetadataIndexEntry peek() {
        if (this.children.isEmpty()) {
            return null;
        }
        return this.children.get(0);
    }

    public int serializeTo(OutputStream outputStream) throws IOException {
        int byteLen = 0;
        byteLen += ReadWriteForEncodingUtils.writeUnsignedVarInt(this.children.size(), outputStream);
        for (MetadataIndexEntry metadataIndexEntry : this.children) {
            byteLen += metadataIndexEntry.serializeTo(outputStream);
        }
        byteLen += ReadWriteIOUtils.write(this.endOffset, outputStream);
        return byteLen += ReadWriteIOUtils.write(this.nodeType.serialize(), outputStream);
    }

    public static MetadataIndexNode deserializeFrom(ByteBuffer buffer) {
        ArrayList<MetadataIndexEntry> children = new ArrayList<MetadataIndexEntry>();
        int size = ReadWriteForEncodingUtils.readUnsignedVarInt(buffer);
        for (int i = 0; i < size; ++i) {
            children.add(MetadataIndexEntry.deserializeFrom(buffer));
        }
        long offset = ReadWriteIOUtils.readLong(buffer);
        MetadataIndexNodeType nodeType = MetadataIndexNodeType.deserialize(ReadWriteIOUtils.readByte(buffer));
        return new MetadataIndexNode(children, offset, nodeType);
    }

    public Pair<MetadataIndexEntry, Long> getChildIndexEntry(String key, boolean exactSearch) {
        int index = this.binarySearchInChildren(key, exactSearch);
        if (index == -1) {
            return null;
        }
        long childEndOffset = index != this.children.size() - 1 ? this.children.get(index + 1).getOffset() : this.endOffset;
        return new Pair<MetadataIndexEntry, Long>(this.children.get(index), childEndOffset);
    }

    int binarySearchInChildren(String key, boolean exactSearch) {
        int low = 0;
        int high = this.children.size() - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            MetadataIndexEntry midVal = this.children.get(mid);
            int cmp = midVal.getName().compareTo(key);
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        if (exactSearch) {
            return -1;
        }
        return low == 0 ? low : low - 1;
    }
}

