/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.file.header;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.statistics.Statistics;
import org.apache.iotdb.tsfile.utils.ReadWriteForEncodingUtils;

public class PageHeader {
    private int uncompressedSize;
    private int compressedSize;
    private Statistics<? extends Serializable> statistics;
    private boolean modified;

    public PageHeader(int uncompressedSize, int compressedSize, Statistics<? extends Serializable> statistics) {
        this.uncompressedSize = uncompressedSize;
        this.compressedSize = compressedSize;
        this.statistics = statistics;
    }

    public static int estimateMaxPageHeaderSizeWithoutStatistics() {
        return 10;
    }

    public static PageHeader deserializeFrom(InputStream inputStream, TSDataType dataType, boolean hasStatistic) throws IOException {
        int uncompressedSize = ReadWriteForEncodingUtils.readUnsignedVarInt(inputStream);
        if (uncompressedSize == 0) {
            return new PageHeader(0, 0, null);
        }
        int compressedSize = ReadWriteForEncodingUtils.readUnsignedVarInt(inputStream);
        Statistics<Serializable> statistics = null;
        if (hasStatistic) {
            statistics = Statistics.deserialize(inputStream, dataType);
        }
        return new PageHeader(uncompressedSize, compressedSize, statistics);
    }

    public static PageHeader deserializeFrom(ByteBuffer buffer, TSDataType dataType) {
        int uncompressedSize = ReadWriteForEncodingUtils.readUnsignedVarInt(buffer);
        if (uncompressedSize == 0) {
            return new PageHeader(0, 0, null);
        }
        int compressedSize = ReadWriteForEncodingUtils.readUnsignedVarInt(buffer);
        Statistics<Serializable> statistics = Statistics.deserialize(buffer, dataType);
        return new PageHeader(uncompressedSize, compressedSize, statistics);
    }

    public static PageHeader deserializeFrom(ByteBuffer buffer, Statistics<? extends Serializable> chunkStatistic) {
        int uncompressedSize = ReadWriteForEncodingUtils.readUnsignedVarInt(buffer);
        if (uncompressedSize == 0) {
            return new PageHeader(0, 0, null);
        }
        int compressedSize = ReadWriteForEncodingUtils.readUnsignedVarInt(buffer);
        return new PageHeader(uncompressedSize, compressedSize, chunkStatistic);
    }

    public int getUncompressedSize() {
        return this.uncompressedSize;
    }

    public void setUncompressedSize(int uncompressedSize) {
        this.uncompressedSize = uncompressedSize;
    }

    public int getCompressedSize() {
        return this.compressedSize;
    }

    public void setCompressedSize(int compressedSize) {
        this.compressedSize = compressedSize;
    }

    public long getNumOfValues() {
        return this.statistics.getCount();
    }

    public Statistics<? extends Serializable> getStatistics() {
        return this.statistics;
    }

    public long getEndTime() {
        return this.statistics.getEndTime();
    }

    public long getStartTime() {
        return this.statistics.getStartTime();
    }

    public int serializeTo(OutputStream outputStream) throws IOException {
        int length = 0;
        length += ReadWriteForEncodingUtils.writeUnsignedVarInt(this.uncompressedSize, outputStream);
        length += ReadWriteForEncodingUtils.writeUnsignedVarInt(this.compressedSize, outputStream);
        return length += this.statistics.serialize(outputStream);
    }

    public String toString() {
        return "PageHeader{uncompressedSize=" + this.uncompressedSize + ", compressedSize=" + this.compressedSize + ", statistics=" + this.statistics + "}";
    }

    public boolean isModified() {
        return this.modified;
    }

    public void setModified(boolean modified) {
        this.modified = modified;
    }

    public int getSerializedPageSize() {
        if (this.uncompressedSize == 0) {
            return ReadWriteForEncodingUtils.uVarIntSize(this.uncompressedSize);
        }
        return ReadWriteForEncodingUtils.uVarIntSize(this.uncompressedSize) + ReadWriteForEncodingUtils.uVarIntSize(this.compressedSize) + (this.statistics == null ? 0 : this.statistics.getSerializedSize()) + this.compressedSize;
    }
}

