/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.util.concurrent.TimeUnit;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.util.RetryCounter;

@InterfaceAudience.Private
public class RetryCounterFactory {
    private final RetryCounter.RetryConfig retryConfig;

    public RetryCounterFactory(int maxAttempts, int sleepIntervalMillis) {
        this(maxAttempts, sleepIntervalMillis, -1);
    }

    public RetryCounterFactory(int maxAttempts, int sleepIntervalMillis, int maxSleepTime) {
        this(new RetryCounter.RetryConfig(maxAttempts, sleepIntervalMillis, maxSleepTime, TimeUnit.MILLISECONDS, new RetryCounter.ExponentialBackoffPolicyWithLimit()));
    }

    public RetryCounterFactory(RetryCounter.RetryConfig retryConfig) {
        this.retryConfig = retryConfig;
    }

    public RetryCounter create() {
        return new RetryCounter(this.retryConfig);
    }
}

