/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.shaded.org.apache.zookeeper.server.quorum;

import org.apache.hadoop.hbase.shaded.org.apache.zookeeper.server.Request;
import org.apache.hadoop.hbase.shaded.org.apache.zookeeper.server.RequestProcessor;
import org.apache.hadoop.hbase.shaded.org.apache.zookeeper.server.SyncRequestProcessor;
import org.apache.hadoop.hbase.shaded.org.apache.zookeeper.server.quorum.AckRequestProcessor;
import org.apache.hadoop.hbase.shaded.org.apache.zookeeper.server.quorum.Leader;
import org.apache.hadoop.hbase.shaded.org.apache.zookeeper.server.quorum.LeaderZooKeeperServer;
import org.apache.hadoop.hbase.shaded.org.apache.zookeeper.server.quorum.LearnerSyncRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProposalRequestProcessor
implements RequestProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(ProposalRequestProcessor.class);
    LeaderZooKeeperServer zks;
    RequestProcessor nextProcessor;
    SyncRequestProcessor syncProcessor;

    public ProposalRequestProcessor(LeaderZooKeeperServer zks, RequestProcessor nextProcessor) {
        this.zks = zks;
        this.nextProcessor = nextProcessor;
        AckRequestProcessor ackProcessor = new AckRequestProcessor(zks.getLeader());
        this.syncProcessor = new SyncRequestProcessor(zks, ackProcessor);
    }

    public void initialize() {
        this.syncProcessor.start();
    }

    @Override
    public void processRequest(Request request) throws RequestProcessor.RequestProcessorException {
        if (request instanceof LearnerSyncRequest) {
            this.zks.getLeader().processSync((LearnerSyncRequest)request);
        } else {
            this.nextProcessor.processRequest(request);
            if (request.hdr != null) {
                try {
                    this.zks.getLeader().propose(request);
                }
                catch (Leader.XidRolloverException e) {
                    throw new RequestProcessor.RequestProcessorException(e.getMessage(), e);
                }
                this.syncProcessor.processRequest(request);
            }
        }
    }

    @Override
    public void shutdown() {
        LOG.info("Shutting down");
        this.nextProcessor.shutdown();
        this.syncProcessor.shutdown();
    }
}

