/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.shaded.org.apache.curator.framework.recipes.locks;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.hbase.shaded.com.google.common.base.Preconditions;
import org.apache.hadoop.hbase.shaded.com.google.common.collect.ImmutableList;
import org.apache.hadoop.hbase.shaded.org.apache.curator.RetryLoop;
import org.apache.hadoop.hbase.shaded.org.apache.curator.framework.CuratorFramework;
import org.apache.hadoop.hbase.shaded.org.apache.curator.framework.api.BackgroundPathable;
import org.apache.hadoop.hbase.shaded.org.apache.curator.framework.api.PathAndBytesable;
import org.apache.hadoop.hbase.shaded.org.apache.curator.framework.imps.CuratorFrameworkState;
import org.apache.hadoop.hbase.shaded.org.apache.curator.framework.recipes.locks.InterProcessMutex;
import org.apache.hadoop.hbase.shaded.org.apache.curator.framework.recipes.locks.Lease;
import org.apache.hadoop.hbase.shaded.org.apache.curator.framework.recipes.shared.SharedCountListener;
import org.apache.hadoop.hbase.shaded.org.apache.curator.framework.recipes.shared.SharedCountReader;
import org.apache.hadoop.hbase.shaded.org.apache.curator.framework.state.ConnectionState;
import org.apache.hadoop.hbase.shaded.org.apache.curator.utils.CloseableUtils;
import org.apache.hadoop.hbase.shaded.org.apache.curator.utils.PathUtils;
import org.apache.hadoop.hbase.shaded.org.apache.curator.utils.ZKPaths;
import org.apache.hadoop.hbase.shaded.org.apache.zookeeper.CreateMode;
import org.apache.hadoop.hbase.shaded.org.apache.zookeeper.KeeperException;
import org.apache.hadoop.hbase.shaded.org.apache.zookeeper.WatchedEvent;
import org.apache.hadoop.hbase.shaded.org.apache.zookeeper.Watcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InterProcessSemaphoreV2 {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final InterProcessMutex lock;
    private final CuratorFramework client;
    private final String leasesPath;
    private final Watcher watcher = new Watcher(){

        @Override
        public void process(WatchedEvent event) {
            InterProcessSemaphoreV2.this.notifyFromWatcher();
        }
    };
    private volatile byte[] nodeData;
    private volatile int maxLeases;
    private static final String LOCK_PARENT = "locks";
    private static final String LEASE_PARENT = "leases";
    private static final String LEASE_BASE_NAME = "lease-";

    public InterProcessSemaphoreV2(CuratorFramework client, String path, int maxLeases) {
        this(client, path, maxLeases, null);
    }

    public InterProcessSemaphoreV2(CuratorFramework client, String path, SharedCountReader count) {
        this(client, path, 0, count);
    }

    private InterProcessSemaphoreV2(CuratorFramework client, String path, int maxLeases, SharedCountReader count) {
        this.client = client;
        path = PathUtils.validatePath(path);
        this.lock = new InterProcessMutex(client, ZKPaths.makePath(path, LOCK_PARENT));
        this.maxLeases = count != null ? count.getCount() : maxLeases;
        this.leasesPath = ZKPaths.makePath(path, LEASE_PARENT);
        if (count != null) {
            count.addListener(new SharedCountListener(){

                @Override
                public void countHasChanged(SharedCountReader sharedCount, int newCount) throws Exception {
                    InterProcessSemaphoreV2.this.maxLeases = newCount;
                    InterProcessSemaphoreV2.this.notifyFromWatcher();
                }

                @Override
                public void stateChanged(CuratorFramework client, ConnectionState newState) {
                }
            });
        }
    }

    public void setNodeData(byte[] nodeData) {
        this.nodeData = nodeData != null ? Arrays.copyOf(nodeData, nodeData.length) : null;
    }

    public Collection<String> getParticipantNodes() throws Exception {
        return (Collection)this.client.getChildren().forPath(this.leasesPath);
    }

    public void returnAll(Collection<Lease> leases) {
        for (Lease l : leases) {
            CloseableUtils.closeQuietly(l);
        }
    }

    public void returnLease(Lease lease) {
        CloseableUtils.closeQuietly(lease);
    }

    public Lease acquire() throws Exception {
        Collection<Lease> leases = this.acquire(1, 0L, null);
        return leases.iterator().next();
    }

    public Collection<Lease> acquire(int qty) throws Exception {
        return this.acquire(qty, 0L, null);
    }

    public Lease acquire(long time, TimeUnit unit) throws Exception {
        Collection<Lease> leases = this.acquire(1, time, unit);
        return leases != null ? leases.iterator().next() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Collection<Lease> acquire(int qty, long time, TimeUnit unit) throws Exception {
        block13: {
            startMs = System.currentTimeMillis();
            hasWait = unit != null;
            waitMs = hasWait != false ? TimeUnit.MILLISECONDS.convert(time, unit) : 0L;
            Preconditions.checkArgument(qty > 0, "qty cannot be 0");
            builder = ImmutableList.builder();
            success = false;
            while (true) {
                if (qty-- <= 0) {
                    success = true;
                    return builder.build();
                }
                break block13;
                break;
            }
            finally {
                if (!success) {
                    this.returnAll(builder.build());
                }
            }
        }
        retryCount = 0;
        startMillis = System.currentTimeMillis();
        isDone = false;
        block10: while (true) {
            if (isDone) ** continue;
            switch (4.$SwitchMap$org$apache$curator$framework$recipes$locks$InterProcessSemaphoreV2$InternalAcquireResult[this.internalAcquire1Lease(builder, startMs, hasWait, waitMs).ordinal()]) {
                case 1: {
                    isDone = true;
                    break;
                }
                case 2: {
                    var16_12 = null;
                    return var16_12;
                }
                case 3: {
                    if (this.client.getZookeeperClient().getRetryPolicy().allowRetry(retryCount++, System.currentTimeMillis() - startMillis, RetryLoop.getDefaultRetrySleeper())) continue block10;
                    throw new KeeperException.NoNodeException("Sequential path not found - possible session loss");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private InternalAcquireResult internalAcquire1Lease(ImmutableList.Builder<Lease> builder, long startMs, boolean hasWait, long waitMs) throws Exception {
        if (this.client.getState() != CuratorFrameworkState.STARTED) {
            return InternalAcquireResult.RETURN_NULL;
        }
        if (hasWait) {
            thisWaitMs = this.getThisWaitMs(startMs, waitMs);
            if (!this.lock.acquire(thisWaitMs, TimeUnit.MILLISECONDS)) {
                return InternalAcquireResult.RETURN_NULL;
            }
        } else {
            this.lock.acquire();
        }
        try {
            createBuilder = (PathAndBytesable)this.client.create().creatingParentsIfNeeded().withProtection().withMode(CreateMode.EPHEMERAL_SEQUENTIAL);
            path = this.nodeData != null ? (String)createBuilder.forPath(ZKPaths.makePath(this.leasesPath, "lease-"), this.nodeData) : (String)createBuilder.forPath(ZKPaths.makePath(this.leasesPath, "lease-"));
            nodeName = ZKPaths.getNodeFromPath(path);
            builder.add((Object)this.makeLease(path));
            var10_9 = this;
            // MONITORENTER : var10_9
            while (true) {
                if ((children = (List)((BackgroundPathable)this.client.getChildren().usingWatcher(this.watcher)).forPath(this.leasesPath)).contains(nodeName)) break block14;
                this.log.error("Sequential path not found: " + path);
                var12_12 = InternalAcquireResult.RETRY_DUE_TO_MISSING_NODE;
                // MONITOREXIT : var10_9
                break;
            }
        }
        catch (Throwable var16_14) {
            this.lock.release();
            throw var16_14;
        }
        {
            block14: {
                this.lock.release();
                return var12_12;
            }
            if (children.size() <= this.maxLeases) {
                this.lock.release();
                return InternalAcquireResult.CONTINUE;
            }
            if (!hasWait) ** GOTO lbl41
            thisWaitMs = this.getThisWaitMs(startMs, waitMs);
            if (thisWaitMs <= 0L) {
                var14_13 = InternalAcquireResult.RETURN_NULL;
                // MONITOREXIT : var10_9
                this.lock.release();
                return var14_13;
            }
            this.wait(thisWaitMs);
            continue;
lbl41:
            // 1 sources

            this.wait();
            continue;
        }
    }

    private long getThisWaitMs(long startMs, long waitMs) {
        long elapsedMs = System.currentTimeMillis() - startMs;
        return waitMs - elapsedMs;
    }

    private Lease makeLease(final String path) {
        return new Lease(){

            @Override
            public void close() throws IOException {
                try {
                    InterProcessSemaphoreV2.this.client.delete().guaranteed().forPath(path);
                }
                catch (KeeperException.NoNodeException e) {
                    InterProcessSemaphoreV2.this.log.warn("Lease already released", (Throwable)e);
                }
                catch (Exception e) {
                    throw new IOException(e);
                }
            }

            @Override
            public byte[] getData() throws Exception {
                return (byte[])InterProcessSemaphoreV2.this.client.getData().forPath(path);
            }
        };
    }

    private synchronized void notifyFromWatcher() {
        this.notifyAll();
    }

    static class 4 {
        static final /* synthetic */ int[] $SwitchMap$org$apache$curator$framework$recipes$locks$InterProcessSemaphoreV2$InternalAcquireResult;

        static {
            $SwitchMap$org$apache$curator$framework$recipes$locks$InterProcessSemaphoreV2$InternalAcquireResult = new int[InternalAcquireResult.values().length];
            try {
                4.$SwitchMap$org$apache$curator$framework$recipes$locks$InterProcessSemaphoreV2$InternalAcquireResult[InternalAcquireResult.CONTINUE.ordinal()] = 1;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                4.$SwitchMap$org$apache$curator$framework$recipes$locks$InterProcessSemaphoreV2$InternalAcquireResult[InternalAcquireResult.RETURN_NULL.ordinal()] = 2;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                4.$SwitchMap$org$apache$curator$framework$recipes$locks$InterProcessSemaphoreV2$InternalAcquireResult[InternalAcquireResult.RETRY_DUE_TO_MISSING_NODE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
        }
    }

    private static enum InternalAcquireResult {
        CONTINUE,
        RETURN_NULL,
        RETRY_DUE_TO_MISSING_NODE;

    }
}

