/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.shaded.io.netty.util.internal.shaded.org.jctools.queues;

import java.util.Iterator;
import org.apache.hadoop.hbase.shaded.io.netty.util.internal.shaded.org.jctools.queues.ConcurrentCircularArrayQueueL0Pad;
import org.apache.hadoop.hbase.shaded.io.netty.util.internal.shaded.org.jctools.queues.SparsePaddedCircularArrayOffsetCalculator;
import org.apache.hadoop.hbase.shaded.io.netty.util.internal.shaded.org.jctools.util.Pow2;

public abstract class ConcurrentCircularArrayQueue<E>
extends ConcurrentCircularArrayQueueL0Pad<E> {
    protected final long mask;
    protected final E[] buffer;

    public ConcurrentCircularArrayQueue(int capacity) {
        int actualCapacity = Pow2.roundToPowerOfTwo(capacity);
        this.mask = actualCapacity - 1;
        this.buffer = SparsePaddedCircularArrayOffsetCalculator.allocate(actualCapacity);
    }

    protected final long calcElementOffset(long index) {
        return ConcurrentCircularArrayQueue.calcElementOffset(index, this.mask);
    }

    protected static long calcElementOffset(long index, long mask) {
        return SparsePaddedCircularArrayOffsetCalculator.calcElementOffset(index, mask);
    }

    @Override
    public Iterator<E> iterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        while (this.poll() != null || !this.isEmpty()) {
        }
    }

    @Override
    public int capacity() {
        return (int)(this.mask + 1L);
    }
}

