/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.util.List;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.client.Result;

@InterfaceAudience.Private
public abstract class ScanResultCache {
    static final Result[] EMPTY_RESULT_ARRAY = new Result[0];
    int numberOfCompleteRows;
    long resultSize = 0L;
    int count = 0;
    Result lastResult = null;
    List<Result> cache;

    ScanResultCache(List<Result> cache) {
        this.cache = cache;
    }

    abstract void loadResultsToCache(Result[] var1, boolean var2) throws IOException;

    void clear() {
        this.resetCount();
        this.resetResultSize();
        this.lastResult = null;
    }

    int numberOfCompleteRows() {
        return this.numberOfCompleteRows;
    }

    void addResultArrayToCache(Result[] resultsToAddToCache, int start, int end) {
        if (resultsToAddToCache != null) {
            for (int r = start; r < end; ++r) {
                this.checkUpdateNumberOfCompleteRowsAndCache(resultsToAddToCache[r]);
            }
        }
    }

    abstract void checkUpdateNumberOfCompleteRowsAndCache(Result var1);

    void addResultToCache(Result rs) {
        this.cache.add(rs);
        for (Cell cell : rs.rawCells()) {
            this.resultSize += CellUtil.estimatedHeapSizeOf(cell);
        }
        ++this.count;
        this.lastResult = rs;
    }

    long getResultSize() {
        return this.resultSize;
    }

    int getCount() {
        return this.count;
    }

    void resetResultSize() {
        this.resultSize = 0L;
    }

    void resetCount() {
        this.count = 0;
    }

    Result getLastResult() {
        return this.lastResult;
    }
}

