/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;

class RetryingTimeTracker {
    private long globalStartTime = -1L;

    RetryingTimeTracker() {
    }

    public RetryingTimeTracker start() {
        if (this.globalStartTime < 0L) {
            this.globalStartTime = EnvironmentEdgeManager.currentTime();
        }
        return this;
    }

    public int getRemainingTime(int callTimeout) {
        if (callTimeout <= 0) {
            return 0;
        }
        if (callTimeout == Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        int remainingTime = (int)((long)callTimeout - (EnvironmentEdgeManager.currentTime() - this.globalStartTime));
        if (remainingTime < 1) {
            remainingTime = 1;
        }
        return remainingTime;
    }

    public long getStartTime() {
        return this.globalStartTime;
    }
}

