/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.commons.logging.Log;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellComparator;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.client.AllowPartialScanResultCache;
import org.apache.hadoop.hbase.client.BatchScanResultCache;
import org.apache.hadoop.hbase.client.ClusterConnection;
import org.apache.hadoop.hbase.client.CompleteScanResultCache;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionAdapter;
import org.apache.hadoop.hbase.client.ConnectionManager;
import org.apache.hadoop.hbase.client.NonceGenerator;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.ScanResultCache;
import org.apache.hadoop.hbase.protobuf.generated.AdminProtos;
import org.apache.hadoop.hbase.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.security.UserProvider;
import org.apache.hadoop.hbase.util.Bytes;

@InterfaceAudience.Private
public class ConnectionUtils {
    static final byte[] MAX_BYTE_ARRAY = Bytes.createMaxByteArray(9);
    private static final Comparator<Cell> COMPARE_WITHOUT_ROW = new Comparator<Cell>(){

        @Override
        public int compare(Cell o1, Cell o2) {
            return CellComparator.compareWithoutRow(o1, o2);
        }
    };

    public static long getPauseTime(long pause, int tries) {
        int ntries = tries;
        if (ntries >= HConstants.RETRY_BACKOFF.length) {
            ntries = HConstants.RETRY_BACKOFF.length - 1;
        }
        if (ntries < 0) {
            ntries = 0;
        }
        long normalPause = pause * (long)HConstants.RETRY_BACKOFF[ntries];
        long jitter = (long)((float)normalPause * ThreadLocalRandom.current().nextFloat() * 0.01f);
        return normalPause + jitter;
    }

    public static NonceGenerator injectNonceGeneratorForTesting(ClusterConnection conn, NonceGenerator cnm) {
        return ConnectionManager.injectNonceGeneratorForTesting(conn, cnm);
    }

    public static void setServerSideHConnectionRetriesConfig(Configuration c, String sn, Log log) {
        int hcRetries = c.getInt("hbase.client.retries.number", 31);
        int serversideMultiplier = c.getInt("hbase.client.serverside.retries.multiplier", 10);
        int retries = hcRetries * serversideMultiplier;
        c.setInt("hbase.client.retries.number", retries);
        log.info((Object)(sn + " server-side HConnection retries=" + retries));
    }

    @Deprecated
    public static ClusterConnection createShortCircuitHConnection(Connection conn, final ServerName serverName, final AdminProtos.AdminService.BlockingInterface admin, final ClientProtos.ClientService.BlockingInterface client) {
        return new ConnectionAdapter(conn){

            @Override
            public AdminProtos.AdminService.BlockingInterface getAdmin(ServerName sn, boolean getMaster) throws IOException {
                return serverName.equals(sn) ? admin : super.getAdmin(sn, getMaster);
            }

            @Override
            public ClientProtos.ClientService.BlockingInterface getClient(ServerName sn) throws IOException {
                return serverName.equals(sn) ? client : super.getClient(sn);
            }
        };
    }

    public static ClusterConnection createShortCircuitConnection(Configuration conf, ExecutorService pool, User user, final ServerName serverName, final AdminProtos.AdminService.BlockingInterface admin, final ClientProtos.ClientService.BlockingInterface client) throws IOException {
        if (user == null) {
            user = UserProvider.instantiate(conf).getCurrent();
        }
        return new ConnectionManager.HConnectionImplementation(conf, false, pool, user){

            @Override
            public AdminProtos.AdminService.BlockingInterface getAdmin(ServerName sn, boolean getMaster) throws IOException {
                return serverName.equals(sn) ? admin : super.getAdmin(sn, getMaster);
            }

            @Override
            public ClientProtos.ClientService.BlockingInterface getClient(ServerName sn) throws IOException {
                return serverName.equals(sn) ? client : super.getClient(sn);
            }
        };
    }

    public static void setupMasterlessConnection(Configuration conf) {
        conf.set("hbase.client.connection.impl", MasterlessConnection.class.getName());
    }

    static String getStubKey(String serviceName, ServerName serverName) {
        return String.format("%s@%s", serviceName, serverName);
    }

    static byte[] createClosestRowAfter(byte[] row) {
        return Arrays.copyOf(row, row.length + 1);
    }

    static byte[] createCloseRowBefore(byte[] row) {
        if (row.length == 0) {
            return MAX_BYTE_ARRAY;
        }
        if (row[row.length - 1] == 0) {
            return Arrays.copyOf(row, row.length - 1);
        }
        byte[] nextRow = new byte[row.length + MAX_BYTE_ARRAY.length];
        System.arraycopy(row, 0, nextRow, 0, row.length - 1);
        nextRow[row.length - 1] = (byte)((row[row.length - 1] & 0xFF) - 1);
        System.arraycopy(MAX_BYTE_ARRAY, 0, nextRow, row.length, MAX_BYTE_ARRAY.length);
        return nextRow;
    }

    static boolean isEmptyStartRow(byte[] row) {
        return Bytes.equals(row, HConstants.EMPTY_START_ROW);
    }

    static boolean isEmptyStopRow(byte[] row) {
        return Bytes.equals(row, HConstants.EMPTY_END_ROW);
    }

    static Result filterCells(Result result, Cell keepCellsAfter) {
        if (keepCellsAfter == null) {
            return result;
        }
        if (!CellUtil.matchingRow(keepCellsAfter, result.getRow(), 0, result.getRow().length)) {
            return result;
        }
        Cell[] rawCells = result.rawCells();
        int index = Arrays.binarySearch(rawCells, keepCellsAfter, COMPARE_WITHOUT_ROW);
        index = index < 0 ? -index - 1 : ++index;
        if (index == 0) {
            return result;
        }
        if (index == rawCells.length) {
            return null;
        }
        return Result.create(Arrays.copyOfRange(rawCells, index, rawCells.length), null, result.isStale(), result.mayHaveMoreCellsInRow());
    }

    static boolean noMoreResultsForScan(Scan scan, HRegionInfo info) {
        if (ConnectionUtils.isEmptyStopRow(info.getEndKey())) {
            return true;
        }
        if (ConnectionUtils.isEmptyStopRow(scan.getStopRow())) {
            return false;
        }
        int c = Bytes.compareTo(info.getEndKey(), scan.getStopRow());
        return c > 0 || c == 0 && !scan.includeStopRow();
    }

    static boolean noMoreResultsForReverseScan(Scan scan, HRegionInfo info) {
        if (ConnectionUtils.isEmptyStartRow(info.getStartKey())) {
            return true;
        }
        if (ConnectionUtils.isEmptyStopRow(scan.getStopRow())) {
            return false;
        }
        return Bytes.compareTo(info.getStartKey(), scan.getStopRow()) <= 0;
    }

    public static ScanResultCache createScanResultCache(Scan scan, List<Result> cache) {
        if (scan.getAllowPartialResults()) {
            return new AllowPartialScanResultCache(cache);
        }
        if (scan.getBatch() > 0) {
            return new BatchScanResultCache(cache, scan.getBatch());
        }
        return new CompleteScanResultCache(cache);
    }

    static class MasterlessConnection
    extends ConnectionManager.HConnectionImplementation {
        MasterlessConnection(Configuration conf, boolean managed, ExecutorService pool, User user) throws IOException {
            super(conf, managed, pool, user);
        }

        @Override
        public boolean isTableDisabled(TableName tableName) throws IOException {
            return false;
        }
    }
}

