/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.codec.prefixtree.decode;

import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.codec.prefixtree.PrefixTreeBlockMeta;
import org.apache.hadoop.hbase.codec.prefixtree.decode.PrefixTreeArrayScanner;
import org.apache.hadoop.hbase.codec.prefixtree.scanner.ReversibleCellScanner;

@InterfaceAudience.Private
public class PrefixTreeArrayReversibleScanner
extends PrefixTreeArrayScanner
implements ReversibleCellScanner {
    public PrefixTreeArrayReversibleScanner(PrefixTreeBlockMeta blockMeta, int rowTreeDepth, int rowBufferLength, int qualifierBufferLength, int tagsBufferLength) {
        super(blockMeta, rowTreeDepth, rowBufferLength, qualifierBufferLength, tagsBufferLength);
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    @Override
    public boolean previous() {
        if (this.afterLast) {
            this.afterLast = false;
            this.positionAtLastCell();
            return true;
        }
        if (this.beforeFirst) {
            return false;
        }
        if (this.isFirstCellInRow()) {
            this.previousRowInternal();
            if (this.beforeFirst) {
                return false;
            }
            this.populateLastNonRowFields();
            return true;
        }
        this.populatePreviousNonRowFields();
        return true;
    }

    @Override
    public boolean previousRow(boolean endOfRow) {
        this.previousRowInternal();
        if (this.beforeFirst) {
            return false;
        }
        if (endOfRow) {
            this.populateLastNonRowFields();
        } else {
            this.populateFirstNonRowFields();
        }
        return true;
    }

    private boolean previousRowInternal() {
        if (this.beforeFirst) {
            return false;
        }
        if (this.afterLast) {
            this.positionAtLastRow();
            return true;
        }
        if (this.currentRowNode.hasOccurrences()) {
            this.discardCurrentRowNode(false);
            if (this.currentRowNode == null) {
                return false;
            }
        }
        while (!this.beforeFirst) {
            if (this.isDirectlyAfterNub()) {
                this.currentRowNode.resetFanIndex();
                this.nubCellsRemain = true;
                return true;
            }
            if (this.currentRowNode.hasPreviousFanNodes()) {
                this.followPreviousFan();
                this.descendToLastRowFromCurrentPosition();
            } else {
                this.discardCurrentRowNode(false);
                if (this.currentRowNode == null) {
                    return false;
                }
            }
            if (!this.currentRowNode.hasOccurrences()) continue;
            this.currentRowNode.resetFanIndex();
            return true;
        }
        return false;
    }

    protected boolean isDirectlyAfterNub() {
        return this.currentRowNode.isNub() && this.currentRowNode.getFanIndex() == 0;
    }

    protected void positionAtLastRow() {
        this.reInitFirstNode();
        this.descendToLastRowFromCurrentPosition();
    }

    protected void descendToLastRowFromCurrentPosition() {
        while (this.currentRowNode.hasChildren()) {
            this.followLastFan();
        }
    }

    protected void positionAtLastCell() {
        this.positionAtLastRow();
        this.populateLastNonRowFields();
    }
}

