/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.metrics.impl;

import com.google.common.base.Supplier;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.hbase.classification.InterfaceAudience;

@InterfaceAudience.Private
class RefCountingMap<K, V> {
    private ConcurrentHashMap<K, Payload<V>> map = new ConcurrentHashMap();

    RefCountingMap() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressWarnings(value={"AT_OPERATION_SEQUENCE_ON_CONCURRENT_ABSTRACTION"}, justification="We use the object monitor to serialize operations on the concurrent map")
    V put(K key, Supplier<V> supplier) {
        RefCountingMap refCountingMap = this;
        synchronized (refCountingMap) {
            Payload<Object> oldValue = this.map.get(key);
            if (oldValue == null) {
                oldValue = new Payload<Object>(supplier.get());
                this.map.put(key, oldValue);
                return oldValue.v;
            }
            oldValue.refCount.incrementAndGet();
            return oldValue.v;
        }
    }

    V get(K k) {
        Payload<V> p = this.map.get(k);
        return p == null ? null : (V)p.v;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    V remove(K key) {
        RefCountingMap refCountingMap = this;
        synchronized (refCountingMap) {
            Payload<V> oldValue = this.map.get(key);
            if (oldValue != null) {
                if (oldValue.refCount.decrementAndGet() == 0) {
                    this.map.remove(key);
                    return null;
                }
                return oldValue.v;
            }
        }
        return null;
    }

    void clear() {
        this.map.clear();
    }

    Set<K> keySet() {
        return this.map.keySet();
    }

    Collection<V> values() {
        ArrayList values = new ArrayList(this.map.size());
        for (Payload<V> v : this.map.values()) {
            values.add(v.v);
        }
        return values;
    }

    int size() {
        return this.map.size();
    }

    private static class Payload<V> {
        V v;
        final AtomicInteger refCount = new AtomicInteger(1);

        Payload(V v) {
            this.v = v;
        }
    }
}

