/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.io.Serializable;
import java.util.LinkedHashMap;
import org.apache.hadoop.hbase.shaded.com.google.common.collect.Lists;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.JRubyFormat;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestJRubyFormat {
    @Test
    public void testPrint() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("null", null);
        map.put("boolean", true);
        map.put("number", 1);
        map.put("string", "str");
        map.put("binary", new byte[]{1, 2, 3});
        map.put("list", Lists.newArrayList((Object[])new Serializable[]{Integer.valueOf(1), "2", Boolean.valueOf(true)}));
        String jrubyString = JRubyFormat.print(map);
        Assert.assertEquals((Object)"{ null => '', boolean => 'true', number => '1', string => 'str', binary => '010203', list => [ '1', '2', 'true' ] }", (Object)jrubyString);
    }

    @Test
    public void testEscape() {
        String jrubyString = JRubyFormat.print((Object)"\\'\n\r\t\f");
        Assert.assertEquals((Object)"'\\\\\\'\\n\\r\\t\\f'", (Object)jrubyString);
    }
}

