/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.util.Arrays;
import java.util.Random;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.FastLongHistogram;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestFastLongHistogram {
    private static void doTestUniform(FastLongHistogram hist) {
        int i;
        long[] VALUES = new long[]{0L, 10L, 20L, 30L, 40L, 50L};
        double[] qs = new double[VALUES.length];
        for (i = 0; i < qs.length; ++i) {
            qs[i] = (double)VALUES[i] / (double)VALUES[VALUES.length - 1];
        }
        for (i = 0; i < 10; ++i) {
            for (long v : VALUES) {
                hist.add(v, 1L);
            }
            long[] vals = hist.getQuantiles(qs);
            System.out.println(Arrays.toString(vals));
            for (int j = 0; j < qs.length; ++j) {
                Assert.assertTrue((String)(j + "-th element org: " + VALUES[j] + ", act: " + vals[j]), (Math.abs(vals[j] - VALUES[j]) <= 10L ? 1 : 0) != 0);
            }
            hist.reset();
        }
    }

    @Test
    public void testUniform() {
        FastLongHistogram hist = new FastLongHistogram(100, 0L, 50L);
        TestFastLongHistogram.doTestUniform(hist);
    }

    @Test
    public void testAdaptionOfChange() {
        FastLongHistogram hist = new FastLongHistogram(100, 0L, 100L);
        Random rand = new Random();
        for (int n = 0; n < 10; ++n) {
            int i;
            for (i = 0; i < 900; ++i) {
                hist.add((long)rand.nextInt(100), 1L);
            }
            for (i = 0; i < 100; ++i) {
                hist.add((long)(1000 + rand.nextInt(100)), 1L);
            }
            long[] vals = hist.getQuantiles(new double[]{0.25, 0.75, 0.95});
            System.out.println(Arrays.toString(vals));
            if (n == 0) {
                Assert.assertTrue((String)"Out of possible value", (vals[0] >= 0L && vals[0] <= 50L ? 1 : 0) != 0);
                Assert.assertTrue((String)"Out of possible value", (vals[1] >= 50L && vals[1] <= 100L ? 1 : 0) != 0);
                Assert.assertTrue((String)"Out of possible value", (vals[2] >= 900L && vals[2] <= 1100L ? 1 : 0) != 0);
            }
            hist.reset();
        }
    }

    @Test
    public void testGetNumAtOrBelow() {
        int i;
        long[] VALUES = new long[]{1L, 10L, 20L, 30L, 40L, 50L};
        FastLongHistogram h = new FastLongHistogram();
        for (long v : VALUES) {
            for (i = 0; i < 100; ++i) {
                h.add(v, 1L);
            }
        }
        h.add(Integer.MAX_VALUE, 1L);
        h.reset();
        for (long v : VALUES) {
            for (i = 0; i < 100; ++i) {
                h.add(v, 1L);
            }
        }
        h.add(Integer.MAX_VALUE, 1L);
        Assert.assertEquals((long)100L, (long)h.getNumAtOrBelow(1L));
        Assert.assertEquals((long)200L, (long)h.getNumAtOrBelow(11L));
        Assert.assertEquals((long)601L, (long)h.getNumAtOrBelow(Long.MAX_VALUE));
    }

    @Test
    public void testSameValues() {
        FastLongHistogram hist = new FastLongHistogram(100);
        hist.add(50L, 100L);
        hist.reset();
        TestFastLongHistogram.doTestUniform(hist);
    }
}

