/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.SimplePositionedByteRange;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestPositionedByteRange {
    @Test
    public void testPosition() {
        SimplePositionedByteRange r = new SimplePositionedByteRange(new byte[5], 1, 3);
        r.put(Bytes.toBytes((String)"f")[0]).put(Bytes.toBytes((String)"o")[0]).put(Bytes.toBytes((String)"o")[0]);
        Assert.assertEquals((long)3L, (long)r.getPosition());
        Assert.assertArrayEquals((byte[])new byte[]{0, Bytes.toBytes((String)"f")[0], Bytes.toBytes((String)"o")[0], Bytes.toBytes((String)"o")[0], 0}, (byte[])r.getBytes());
        r.setPosition(0);
        r.put(Bytes.toBytes((String)"f")).put(Bytes.toBytes((String)"o")).put(Bytes.toBytes((String)"o"));
        Assert.assertEquals((long)3L, (long)r.getPosition());
        Assert.assertArrayEquals((byte[])new byte[]{0, Bytes.toBytes((String)"f")[0], Bytes.toBytes((String)"o")[0], Bytes.toBytes((String)"o")[0], 0}, (byte[])r.getBytes());
        r.setPosition(0);
        Assert.assertEquals((long)Bytes.toBytes((String)"f")[0], (long)r.get());
        Assert.assertEquals((long)Bytes.toBytes((String)"o")[0], (long)r.get());
        Assert.assertEquals((long)Bytes.toBytes((String)"o")[0], (long)r.get());
        r.setPosition(1);
        Assert.assertEquals((long)Bytes.toBytes((String)"o")[0], (long)r.get());
        r.setPosition(0);
        byte[] dst = new byte[3];
        r.get(dst);
        Assert.assertArrayEquals((byte[])Bytes.toBytes((String)"foo"), (byte[])dst);
        r.setPosition(3);
    }
}

