/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.exceptions;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.NotServingRegionException;
import org.apache.hadoop.hbase.ServerName;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class RegionMovedException
extends NotServingRegionException {
    private static final Log LOG = LogFactory.getLog(RegionMovedException.class);
    private static final long serialVersionUID = -7232903522310558396L;
    private final String hostname;
    private final int port;
    private final long startCode;
    private final long locationSeqNum;
    private static final String HOST_FIELD = "hostname=";
    private static final String PORT_FIELD = "port=";
    private static final String STARTCODE_FIELD = "startCode=";
    private static final String LOCATIONSEQNUM_FIELD = "locationSeqNum=";

    public RegionMovedException(ServerName serverName, long locationSeqNum) {
        this.hostname = serverName.getHostname();
        this.port = serverName.getPort();
        this.startCode = serverName.getStartcode();
        this.locationSeqNum = locationSeqNum;
    }

    public String getHostname() {
        return this.hostname;
    }

    public int getPort() {
        return this.port;
    }

    public ServerName getServerName() {
        return ServerName.valueOf((String)this.hostname, (int)this.port, (long)this.startCode);
    }

    public long getLocationSeqNum() {
        return this.locationSeqNum;
    }

    public RegionMovedException(String s) {
        int posHostname = s.indexOf(HOST_FIELD) + HOST_FIELD.length();
        int posPort = s.indexOf(PORT_FIELD) + PORT_FIELD.length();
        int posStartCode = s.indexOf(STARTCODE_FIELD) + STARTCODE_FIELD.length();
        int posSeqNum = s.indexOf(LOCATIONSEQNUM_FIELD) + LOCATIONSEQNUM_FIELD.length();
        String tmpHostname = null;
        int tmpPort = -1;
        long tmpStartCode = -1L;
        long tmpSeqNum = -1L;
        try {
            tmpHostname = s.substring(posHostname, s.indexOf(32, posHostname));
            tmpPort = Integer.parseInt(s.substring(posPort, s.indexOf(32, posPort)));
            tmpStartCode = Long.parseLong(s.substring(posStartCode, s.indexOf(46, posStartCode)));
            tmpSeqNum = Long.parseLong(s.substring(posSeqNum, s.indexOf(46, posSeqNum)));
        }
        catch (Exception ignored) {
            LOG.warn((Object)("Can't parse the hostname, port and startCode from this string: " + s + ", continuing"));
        }
        this.hostname = tmpHostname;
        this.port = tmpPort;
        this.startCode = tmpStartCode;
        this.locationSeqNum = tmpSeqNum;
    }

    @Override
    public String getMessage() {
        return "Region moved to: hostname=" + this.hostname + " " + PORT_FIELD + this.port + " " + STARTCODE_FIELD + this.startCode + ". As of " + LOCATIONSEQNUM_FIELD + this.locationSeqNum + ".";
    }
}

