/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Row;
import org.apache.hadoop.hbase.client.WrongRowIOException;
import org.apache.hadoop.hbase.io.TimeRange;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.ClassSize;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class Increment
extends Mutation
implements Comparable<Row> {
    private static final long HEAP_OVERHEAD = ClassSize.REFERENCE + ClassSize.TIMERANGE;
    private TimeRange tr = new TimeRange();

    public Increment(byte[] row) {
        this(row, 0, row.length);
    }

    public Increment(byte[] row, int offset, int length) {
        Increment.checkRow(row, offset, length);
        this.row = Bytes.copy((byte[])row, (int)offset, (int)length);
    }

    public Increment(Increment i) {
        this.row = i.getRow();
        this.ts = i.getTimeStamp();
        this.tr = i.getTimeRange();
        this.familyMap.putAll(i.getFamilyCellMap());
        for (Map.Entry<String, byte[]> entry : i.getAttributesMap().entrySet()) {
            this.setAttribute(entry.getKey(), entry.getValue());
        }
    }

    public Increment add(Cell cell) throws IOException {
        KeyValue kv = KeyValueUtil.ensureKeyValue((Cell)cell);
        byte[] family = kv.getFamily();
        List<Cell> list = this.getCellList(family);
        int res = Bytes.compareTo((byte[])this.row, (int)0, (int)this.row.length, (byte[])kv.getBuffer(), (int)kv.getRowOffset(), (int)kv.getRowLength());
        if (res != 0) {
            throw new WrongRowIOException("The row in " + kv.toString() + " doesn't match the original one " + Bytes.toStringBinary((byte[])this.row));
        }
        list.add((Cell)kv);
        this.familyMap.put(family, list);
        return this;
    }

    public Increment addColumn(byte[] family, byte[] qualifier, long amount) {
        if (family == null) {
            throw new IllegalArgumentException("family cannot be null");
        }
        if (qualifier == null) {
            throw new IllegalArgumentException("qualifier cannot be null");
        }
        List<Cell> list = this.getCellList(family);
        KeyValue kv = this.createPutKeyValue(family, qualifier, this.ts, Bytes.toBytes((long)amount));
        list.add((Cell)kv);
        this.familyMap.put(kv.getFamily(), list);
        return this;
    }

    public TimeRange getTimeRange() {
        return this.tr;
    }

    public Increment setTimeRange(long minStamp, long maxStamp) throws IOException {
        this.tr = new TimeRange(minStamp, maxStamp);
        return this;
    }

    @Override
    public int numFamilies() {
        return this.familyMap.size();
    }

    public boolean hasFamilies() {
        return !this.familyMap.isEmpty();
    }

    public Map<byte[], NavigableMap<byte[], Long>> getFamilyMapOfLongs() {
        NavigableMap<byte[], List<Cell>> map = super.getFamilyCellMap();
        TreeMap<byte[], NavigableMap<byte[], Long>> results = new TreeMap<byte[], NavigableMap<byte[], Long>>(Bytes.BYTES_COMPARATOR);
        for (Map.Entry entry : map.entrySet()) {
            TreeMap<byte[], Long> longs = new TreeMap<byte[], Long>(Bytes.BYTES_COMPARATOR);
            for (Cell cell : (List)entry.getValue()) {
                KeyValue kv = KeyValueUtil.ensureKeyValue((Cell)cell);
                longs.put(kv.getQualifier(), Bytes.toLong((byte[])kv.getValueArray(), (int)kv.getValueOffset(), (int)kv.getValueLength()));
            }
            results.put((byte[])entry.getKey(), (NavigableMap<byte[], Long>)longs);
        }
        return results;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("row=");
        sb.append(Bytes.toStringBinary((byte[])this.row));
        if (this.familyMap.size() == 0) {
            sb.append(", no columns set to be incremented");
            return sb.toString();
        }
        sb.append(", families=");
        boolean moreThanOne = false;
        for (Map.Entry entry : this.familyMap.entrySet()) {
            if (moreThanOne) {
                sb.append("), ");
            } else {
                moreThanOne = true;
                sb.append("{");
            }
            sb.append("(family=");
            sb.append(Bytes.toString((byte[])((byte[])entry.getKey())));
            sb.append(", columns=");
            if (entry.getValue() == null) {
                sb.append("NONE");
                continue;
            }
            sb.append("{");
            boolean moreThanOneB = false;
            for (Cell cell : (List)entry.getValue()) {
                if (moreThanOneB) {
                    sb.append(", ");
                } else {
                    moreThanOneB = true;
                }
                KeyValue kv = KeyValueUtil.ensureKeyValue((Cell)cell);
                sb.append(Bytes.toStringBinary((byte[])kv.getKey()) + "+=" + Bytes.toLong((byte[])kv.getValueArray(), (int)kv.getValueOffset(), (int)kv.getValueLength()));
            }
            sb.append("}");
        }
        sb.append("}");
        return sb.toString();
    }

    @Override
    public int compareTo(Row i) {
        return Bytes.compareTo((byte[])this.getRow(), (byte[])i.getRow());
    }

    public int hashCode() {
        return Bytes.hashCode((byte[])this.getRow());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Row other = (Row)obj;
        return this.compareTo(other) == 0;
    }

    @Override
    protected long extraHeapSize() {
        return HEAP_OVERHEAD;
    }
}

