/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.filter;

import com.google.protobuf.ZeroCopyLiteralByteString;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.protobuf.generated.ComparatorProtos;
import org.apache.hadoop.hbase.util.Bytes;

@InterfaceAudience.Public
@InterfaceStability.Stable
public abstract class ByteArrayComparable
implements Comparable<byte[]> {
    byte[] value;

    public ByteArrayComparable(byte[] value) {
        this.value = value;
    }

    public byte[] getValue() {
        return this.value;
    }

    public abstract byte[] toByteArray();

    ComparatorProtos.ByteArrayComparable convert() {
        ComparatorProtos.ByteArrayComparable.Builder builder = ComparatorProtos.ByteArrayComparable.newBuilder();
        if (this.value != null) {
            builder.setValue(ZeroCopyLiteralByteString.wrap((byte[])this.value));
        }
        return builder.build();
    }

    public static ByteArrayComparable parseFrom(byte[] pbBytes) throws DeserializationException {
        throw new DeserializationException("parseFrom called on base ByteArrayComparable, but should be called on derived type");
    }

    boolean areSerializedFieldsEqual(ByteArrayComparable other) {
        if (other == this) {
            return true;
        }
        return Bytes.equals((byte[])this.getValue(), (byte[])other.getValue());
    }

    @Override
    public int compareTo(byte[] value) {
        return this.compareTo(value, 0, value.length);
    }

    public abstract int compareTo(byte[] var1, int var2, int var3);
}

