/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.websocket;

import java.io.IOException;
import java.util.List;
import javax.websocket.CloseReason;
import javax.websocket.Endpoint;
import javax.websocket.EndpointConfig;
import javax.websocket.MessageHandler;
import javax.websocket.OnClose;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import javax.websocket.RemoteEndpoint;
import javax.websocket.Session;
import org.apache.guacamole.GuacamoleClientException;
import org.apache.guacamole.GuacamoleConnectionClosedException;
import org.apache.guacamole.GuacamoleException;
import org.apache.guacamole.io.GuacamoleReader;
import org.apache.guacamole.net.GuacamoleTunnel;
import org.apache.guacamole.protocol.FilteredGuacamoleWriter;
import org.apache.guacamole.protocol.GuacamoleFilter;
import org.apache.guacamole.protocol.GuacamoleInstruction;
import org.apache.guacamole.protocol.GuacamoleStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class GuacamoleWebSocketTunnelEndpoint
extends Endpoint {
    private static final int BUFFER_SIZE = 8192;
    private static final String PING_OPCODE = "ping";
    private final Logger logger = LoggerFactory.getLogger(GuacamoleWebSocketTunnelEndpoint.class);
    private GuacamoleTunnel tunnel;
    private RemoteEndpoint.Basic remote;

    private void closeConnection(Session session, int guacamoleStatusCode, int webSocketCode) {
        try {
            CloseReason.CloseCode code = CloseReason.CloseCodes.getCloseCode((int)webSocketCode);
            String message = Integer.toString(guacamoleStatusCode);
            session.close(new CloseReason(code, message));
        }
        catch (IOException e) {
            this.logger.debug("Unable to close WebSocket connection.", (Throwable)e);
        }
    }

    private void closeConnection(Session session, GuacamoleStatus guacStatus) {
        this.closeConnection(session, guacStatus.getGuacamoleStatusCode(), guacStatus.getWebSocketCode());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendInstruction(String instruction) throws IOException {
        RemoteEndpoint.Basic basic = this.remote;
        synchronized (basic) {
            this.remote.sendText(instruction);
        }
    }

    private void sendInstruction(GuacamoleInstruction instruction) throws IOException {
        this.sendInstruction(instruction.toString());
    }

    protected abstract GuacamoleTunnel createTunnel(Session var1, EndpointConfig var2) throws GuacamoleException;

    @OnOpen
    public void onOpen(final Session session, EndpointConfig config) {
        this.remote = session.getBasicRemote();
        try {
            this.tunnel = this.createTunnel(session, config);
            if (this.tunnel == null) {
                this.closeConnection(session, GuacamoleStatus.RESOURCE_NOT_FOUND);
                return;
            }
        }
        catch (GuacamoleException e) {
            this.logger.error("Creation of WebSocket tunnel to guacd failed: {}", (Object)e.getMessage());
            this.logger.debug("Error connecting WebSocket tunnel.", (Throwable)e);
            this.closeConnection(session, e.getStatus().getGuacamoleStatusCode(), e.getWebSocketCode());
            return;
        }
        session.addMessageHandler((MessageHandler)new MessageHandler.Whole<String>(){

            public void onMessage(String message) {
                GuacamoleWebSocketTunnelEndpoint.this.onMessage(message);
            }
        });
        Thread readThread = new Thread(){

            @Override
            public void run() {
                StringBuilder buffer = new StringBuilder(8192);
                GuacamoleReader reader = GuacamoleWebSocketTunnelEndpoint.this.tunnel.acquireReader();
                try {
                    GuacamoleWebSocketTunnelEndpoint.this.sendInstruction(new GuacamoleInstruction("", GuacamoleWebSocketTunnelEndpoint.this.tunnel.getUUID().toString()));
                    try {
                        char[] readMessage;
                        while ((readMessage = reader.read()) != null) {
                            buffer.append(readMessage);
                            if (reader.available() && buffer.length() < 8192) continue;
                            GuacamoleWebSocketTunnelEndpoint.this.sendInstruction(buffer.toString());
                            buffer.setLength(0);
                        }
                        GuacamoleWebSocketTunnelEndpoint.this.closeConnection(session, GuacamoleStatus.SUCCESS);
                    }
                    catch (GuacamoleClientException e) {
                        GuacamoleWebSocketTunnelEndpoint.this.logger.info("WebSocket connection terminated: {}", (Object)e.getMessage());
                        GuacamoleWebSocketTunnelEndpoint.this.logger.debug("WebSocket connection terminated due to client error.", (Throwable)e);
                        GuacamoleWebSocketTunnelEndpoint.this.closeConnection(session, e.getStatus().getGuacamoleStatusCode(), e.getWebSocketCode());
                    }
                    catch (GuacamoleConnectionClosedException e) {
                        GuacamoleWebSocketTunnelEndpoint.this.logger.debug("Connection to guacd closed.", (Throwable)e);
                        GuacamoleWebSocketTunnelEndpoint.this.closeConnection(session, GuacamoleStatus.SUCCESS);
                    }
                    catch (GuacamoleException e) {
                        GuacamoleWebSocketTunnelEndpoint.this.logger.error("Connection to guacd terminated abnormally: {}", (Object)e.getMessage());
                        GuacamoleWebSocketTunnelEndpoint.this.logger.debug("Internal error during connection to guacd.", (Throwable)e);
                        GuacamoleWebSocketTunnelEndpoint.this.closeConnection(session, e.getStatus().getGuacamoleStatusCode(), e.getWebSocketCode());
                    }
                }
                catch (IOException e) {
                    GuacamoleWebSocketTunnelEndpoint.this.logger.debug("I/O error prevents further reads.", (Throwable)e);
                    GuacamoleWebSocketTunnelEndpoint.this.closeConnection(session, GuacamoleStatus.SERVER_ERROR);
                }
            }
        };
        readThread.start();
    }

    @OnMessage
    public void onMessage(String message) {
        if (this.tunnel == null) {
            return;
        }
        FilteredGuacamoleWriter writer = new FilteredGuacamoleWriter(this.tunnel.acquireWriter(), new GuacamoleFilter(){

            @Override
            public GuacamoleInstruction filter(GuacamoleInstruction instruction) throws GuacamoleException {
                if (instruction.getOpcode().equals("")) {
                    List<String> args = instruction.getArgs();
                    if (args.size() >= 2 && args.get(0).equals(GuacamoleWebSocketTunnelEndpoint.PING_OPCODE)) {
                        try {
                            GuacamoleWebSocketTunnelEndpoint.this.sendInstruction(new GuacamoleInstruction("", GuacamoleWebSocketTunnelEndpoint.PING_OPCODE, args.get(1)));
                        }
                        catch (IOException e) {
                            GuacamoleWebSocketTunnelEndpoint.this.logger.debug("Unable to send \"ping\" response for WebSocket tunnel.", (Throwable)e);
                        }
                    }
                    return null;
                }
                return instruction;
            }
        });
        try {
            writer.write(message.toCharArray());
        }
        catch (GuacamoleConnectionClosedException e) {
            this.logger.debug("Connection to guacd closed.", (Throwable)e);
        }
        catch (GuacamoleException e) {
            this.logger.debug("WebSocket tunnel write failed.", (Throwable)e);
        }
        this.tunnel.releaseWriter();
    }

    @OnClose
    public void onClose(Session session, CloseReason closeReason) {
        try {
            if (this.tunnel != null) {
                this.tunnel.close();
            }
        }
        catch (GuacamoleException e) {
            this.logger.debug("Unable to close WebSocket tunnel.", (Throwable)e);
        }
    }
}

