/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.protocol;

import org.apache.guacamole.GuacamoleClientBadTypeException;
import org.apache.guacamole.GuacamoleClientException;
import org.apache.guacamole.GuacamoleClientOverrunException;
import org.apache.guacamole.GuacamoleClientTimeoutException;
import org.apache.guacamole.GuacamoleClientTooManyException;
import org.apache.guacamole.GuacamoleException;
import org.apache.guacamole.GuacamoleResourceClosedException;
import org.apache.guacamole.GuacamoleResourceConflictException;
import org.apache.guacamole.GuacamoleResourceNotFoundException;
import org.apache.guacamole.GuacamoleSecurityException;
import org.apache.guacamole.GuacamoleServerBusyException;
import org.apache.guacamole.GuacamoleServerException;
import org.apache.guacamole.GuacamoleSessionClosedException;
import org.apache.guacamole.GuacamoleSessionConflictException;
import org.apache.guacamole.GuacamoleSessionTimeoutException;
import org.apache.guacamole.GuacamoleUnauthorizedException;
import org.apache.guacamole.GuacamoleUnsupportedException;
import org.apache.guacamole.GuacamoleUpstreamException;
import org.apache.guacamole.GuacamoleUpstreamNotFoundException;
import org.apache.guacamole.GuacamoleUpstreamTimeoutException;
import org.apache.guacamole.GuacamoleUpstreamUnavailableException;

public enum GuacamoleStatus {
    SUCCESS(200, 1000, 0){

        @Override
        public GuacamoleException toException(String message) {
            throw new IllegalStateException("The Guacamole protocol SUCCESS status code cannot be converted into a GuacamoleException.", new GuacamoleServerException(message));
        }
    }
    ,
    UNSUPPORTED(501, 1011, 256){

        @Override
        public GuacamoleException toException(String message) {
            return new GuacamoleUnsupportedException(message);
        }
    }
    ,
    SERVER_ERROR(500, 1011, 512){

        @Override
        public GuacamoleException toException(String message) {
            return new GuacamoleServerException(message);
        }
    }
    ,
    SERVER_BUSY(503, 1008, 513){

        @Override
        public GuacamoleException toException(String message) {
            return new GuacamoleServerBusyException(message);
        }
    }
    ,
    UPSTREAM_TIMEOUT(504, 1011, 514){

        @Override
        public GuacamoleException toException(String message) {
            return new GuacamoleUpstreamTimeoutException(message);
        }
    }
    ,
    UPSTREAM_ERROR(502, 1011, 515){

        @Override
        public GuacamoleException toException(String message) {
            return new GuacamoleUpstreamException(message);
        }
    }
    ,
    RESOURCE_NOT_FOUND(404, 1002, 516){

        @Override
        public GuacamoleException toException(String message) {
            return new GuacamoleResourceNotFoundException(message);
        }
    }
    ,
    RESOURCE_CONFLICT(409, 1008, 517){

        @Override
        public GuacamoleException toException(String message) {
            return new GuacamoleResourceConflictException(message);
        }
    }
    ,
    RESOURCE_CLOSED(404, 1002, 518){

        @Override
        public GuacamoleException toException(String message) {
            return new GuacamoleResourceClosedException(message);
        }
    }
    ,
    UPSTREAM_NOT_FOUND(502, 1011, 519){

        @Override
        public GuacamoleException toException(String message) {
            return new GuacamoleUpstreamNotFoundException(message);
        }
    }
    ,
    UPSTREAM_UNAVAILABLE(502, 1011, 520){

        @Override
        public GuacamoleException toException(String message) {
            return new GuacamoleUpstreamUnavailableException(message);
        }
    }
    ,
    SESSION_CONFLICT(409, 1008, 521){

        @Override
        public GuacamoleException toException(String message) {
            return new GuacamoleSessionConflictException(message);
        }
    }
    ,
    SESSION_TIMEOUT(408, 1002, 522){

        @Override
        public GuacamoleException toException(String message) {
            return new GuacamoleSessionTimeoutException(message);
        }
    }
    ,
    SESSION_CLOSED(404, 1002, 523){

        @Override
        public GuacamoleException toException(String message) {
            return new GuacamoleSessionClosedException(message);
        }
    }
    ,
    CLIENT_BAD_REQUEST(400, 1002, 768){

        @Override
        public GuacamoleException toException(String message) {
            return new GuacamoleClientException(message);
        }
    }
    ,
    CLIENT_UNAUTHORIZED(403, 1008, 769){

        @Override
        public GuacamoleException toException(String message) {
            return new GuacamoleUnauthorizedException(message);
        }
    }
    ,
    CLIENT_FORBIDDEN(403, 1008, 771){

        @Override
        public GuacamoleException toException(String message) {
            return new GuacamoleSecurityException(message);
        }
    }
    ,
    CLIENT_TIMEOUT(408, 1002, 776){

        @Override
        public GuacamoleException toException(String message) {
            return new GuacamoleClientTimeoutException(message);
        }
    }
    ,
    CLIENT_OVERRUN(413, 1009, 781){

        @Override
        public GuacamoleException toException(String message) {
            return new GuacamoleClientOverrunException(message);
        }
    }
    ,
    CLIENT_BAD_TYPE(415, 1003, 783){

        @Override
        public GuacamoleException toException(String message) {
            return new GuacamoleClientBadTypeException(message);
        }
    }
    ,
    CLIENT_TOO_MANY(429, 1008, 797){

        @Override
        public GuacamoleException toException(String message) {
            return new GuacamoleClientTooManyException(message);
        }
    };

    private final int http_code;
    private final int websocket_code;
    private final int guac_code;

    private GuacamoleStatus(int http_code, int websocket_code, int guac_code) {
        this.http_code = http_code;
        this.websocket_code = websocket_code;
        this.guac_code = guac_code;
    }

    public int getHttpStatusCode() {
        return this.http_code;
    }

    public int getWebSocketCode() {
        return this.websocket_code;
    }

    public int getGuacamoleStatusCode() {
        return this.guac_code;
    }

    public static GuacamoleStatus fromGuacamoleStatusCode(int code) {
        for (GuacamoleStatus status : GuacamoleStatus.values()) {
            if (status.getGuacamoleStatusCode() != code) continue;
            return status;
        }
        return null;
    }

    public abstract GuacamoleException toException(String var1);
}

