/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.net;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import org.apache.guacamole.GuacamoleException;
import org.apache.guacamole.GuacamoleServerException;
import org.apache.guacamole.GuacamoleUpstreamTimeoutException;
import org.apache.guacamole.io.GuacamoleReader;
import org.apache.guacamole.io.GuacamoleWriter;
import org.apache.guacamole.io.ReaderGuacamoleReader;
import org.apache.guacamole.io.WriterGuacamoleWriter;
import org.apache.guacamole.net.GuacamoleSocket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InetGuacamoleSocket
implements GuacamoleSocket {
    private Logger logger = LoggerFactory.getLogger(InetGuacamoleSocket.class);
    private GuacamoleReader reader;
    private GuacamoleWriter writer;
    private static final int SOCKET_TIMEOUT = 15000;
    private Socket sock;

    public InetGuacamoleSocket(String hostname, int port) throws GuacamoleException {
        try {
            this.logger.debug("Connecting to guacd at {}:{}.", (Object)hostname, (Object)port);
            InetSocketAddress address = new InetSocketAddress(InetAddress.getByName(hostname), port);
            this.sock = new Socket();
            this.sock.connect(address, 15000);
            this.sock.setSoTimeout(15000);
            this.sock.setTcpNoDelay(true);
            this.reader = new ReaderGuacamoleReader(new InputStreamReader(this.sock.getInputStream(), "UTF-8"));
            this.writer = new WriterGuacamoleWriter(new OutputStreamWriter(this.sock.getOutputStream(), "UTF-8"));
        }
        catch (SocketTimeoutException e) {
            throw new GuacamoleUpstreamTimeoutException("Connection timed out.", e);
        }
        catch (IOException e) {
            throw new GuacamoleServerException(e);
        }
    }

    @Override
    public void close() throws GuacamoleException {
        try {
            this.logger.debug("Closing socket to guacd.");
            this.sock.close();
        }
        catch (IOException e) {
            throw new GuacamoleServerException(e);
        }
    }

    @Override
    public GuacamoleReader getReader() {
        return this.reader;
    }

    @Override
    public GuacamoleWriter getWriter() {
        return this.writer;
    }

    @Override
    public boolean isOpen() {
        return !this.sock.isClosed();
    }
}

