/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.upserttest.sink;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import org.apache.flink.api.common.serialization.SerializationSchema;
import org.apache.flink.api.connector.sink2.SinkWriter;
import org.apache.flink.connector.upserttest.sink.ImmutableByteArrayWrapper;
import org.apache.flink.connector.upserttest.sink.UpsertTestFileUtil;
import org.apache.flink.util.FlinkRuntimeException;
import org.apache.flink.util.Preconditions;

class UpsertTestSinkWriter<IN>
implements SinkWriter<IN> {
    private final SerializationSchema<IN> keySerializationSchema;
    private final SerializationSchema<IN> valueSerializationSchema;
    private final Map<ImmutableByteArrayWrapper, ImmutableByteArrayWrapper> records = new HashMap<ImmutableByteArrayWrapper, ImmutableByteArrayWrapper>();
    private final BufferedOutputStream bufferedOutputStream;

    UpsertTestSinkWriter(File outputFile, SerializationSchema<IN> keySerializationSchema, SerializationSchema<IN> valueSerializationSchema) {
        this.keySerializationSchema = (SerializationSchema)Preconditions.checkNotNull(keySerializationSchema);
        this.valueSerializationSchema = (SerializationSchema)Preconditions.checkNotNull(valueSerializationSchema);
        Preconditions.checkNotNull((Object)outputFile);
        try {
            Files.createDirectories(outputFile.toPath().getParent(), new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new FlinkRuntimeException("Could not parent directories for path: " + outputFile);
        }
        try {
            this.bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(outputFile, true));
        }
        catch (FileNotFoundException e) {
            throw new FlinkRuntimeException("Could not find file", (Throwable)e);
        }
    }

    public void write(IN element, SinkWriter.Context context) {
        byte[] key = this.keySerializationSchema.serialize(element);
        byte[] value = this.valueSerializationSchema.serialize(element);
        this.records.put(new ImmutableByteArrayWrapper(key), new ImmutableByteArrayWrapper(value));
    }

    public void flush(boolean endOfInput) throws IOException {
        UpsertTestFileUtil.writeRecords(this.bufferedOutputStream, this.records);
        this.records.clear();
    }

    public void close() throws Exception {
        this.flush(true);
        this.bufferedOutputStream.close();
    }
}

