/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.testutils.junit.extensions.retry;

import java.util.Map;
import org.apache.flink.testutils.junit.extensions.retry.RetryExtension;
import org.apache.flink.testutils.junit.extensions.retry.strategy.RetryStrategy;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.ConditionEvaluationResult;
import org.junit.jupiter.api.extension.ExecutionCondition;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.TestExecutionExceptionHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RetryTestExecutionExtension
implements ExecutionCondition,
TestExecutionExceptionHandler,
AfterEachCallback {
    private static final Logger LOG = LoggerFactory.getLogger(RetryTestExecutionExtension.class);
    private final int retryIndex;
    private final int totalTimes;

    public RetryTestExecutionExtension(int retryIndex, int totalTimes) {
        this.retryIndex = retryIndex;
        this.totalTimes = totalTimes;
    }

    public ConditionEvaluationResult evaluateExecutionCondition(ExtensionContext context) {
        RetryStrategy retryStrategy = this.getRetryStrategyInStore(context);
        String method = RetryExtension.getTestMethodKey(context);
        if (!retryStrategy.hasNextAttempt()) {
            return ConditionEvaluationResult.disabled((String)(method + "has already passed or failed."));
        }
        return ConditionEvaluationResult.enabled((String)String.format("Test %s[%d/%d]", method, this.retryIndex, this.totalTimes));
    }

    public void handleTestExecutionException(ExtensionContext context, Throwable throwable) throws Throwable {
        RetryStrategy retryStrategy = this.getRetryStrategyInStore(context);
        String method = RetryExtension.getTestMethodKey(context);
        retryStrategy.handleException(method, this.retryIndex, throwable);
    }

    public void afterEach(ExtensionContext context) throws Exception {
        Throwable exception = context.getExecutionException().orElse(null);
        if (exception == null) {
            RetryStrategy retryStrategy = this.getRetryStrategyInStore(context);
            String method = RetryExtension.getTestMethodKey(context);
            retryStrategy.stopFollowingAttempts();
            LOG.trace(String.format("Retry test %s[%d/%d] passed, stop retrying.", method, this.retryIndex, this.totalTimes));
        }
    }

    private RetryStrategy getRetryStrategyInStore(ExtensionContext context) {
        Map retryStrategies = (Map)context.getStore(RetryExtension.RETRY_NAMESPACE).get((Object)"testRetry");
        String method = RetryExtension.getTestMethodKey(context);
        return (RetryStrategy)retryStrategies.get(method);
    }
}

